//https://jo.dreggn.org/home/2010_atrous.pdf
//https://github.com/LWJGL/lwjgl3-demos/blob/main/res/org/lwjgl/demo/opengl/raytracing/tutorial8/atrous.fs.glsl

const bool colortex11MipmapEnabled = true;

vec4 indirect_filter(vec2 coord, vec3 normal, float depth, const float size){
    const int steps = 1;
    const float n = 128.0;
    const float d = 64.0;

    vec4 color = vec4(0.0, 0.0, 0.0, 0.0);
    float weight = 0.0;

    for(int i = -steps; i <= steps; ++i){
        for(int j = -steps; j <= steps; ++j){
            vec2 offset = coord + vec2(i, j) * inverse_texel * size;

            uvec4 gbuffers9 = texture(colortex9, offset);

            vec3 s_normal = decode_unit_vector(unpackSnorm4x8(gbuffers9.z).xy);
            float s_depth = projection_depth(texture2(depthtex1, offset).x);

            float w_normal = saturate(dot(normal, s_normal));
                  w_normal = pow(w_normal, n);

            float w_depth = abs(depth - s_depth) * d;
                  w_depth = exp(-w_depth / depth);

            float s_length = length(vec2(i, j));
            float s_weight = filter_gaussian(s_length, 2.0) * w_normal * w_depth;

            color += texture2(colortex11, offset) * s_weight;
            weight += s_weight;
        }
    }

    #ifdef INDIRECT_FILTER
        return color / weight;
    #else   
        return texture2(colortex11, coord);
    #endif
}