vec2 noise_fbm(vec2 position, vec2 direction, float time_shift, int octaves){
    float amplitude = 0.5;
    float frequency = 1.5;

    vec2 noise = amplitude * texture(noisetex, position).xy;

    for(int i = 0; i < octaves; i++){
        noise += amplitude * texture(noisetex, position).xy;
        position = direction + position * frequency;
        amplitude *= 0.5;
    }

    noise = curve(noise);

    vec2 s = sin(noise + time_shift * 0.5);
    vec2 c = cos(noise + time_shift * 0.25);

    return (s + c) * 0.5 + 0.5;
}

vec3 grass_animation(vec3 position, bool tall){
    float time = frameTimeCounter * 1.2;

    vec2 sample_direction = time * vec2(-1, 1);
    vec2 sample_noise = noise_fbm(position.xz * 0.7, sample_direction, time, 4);
    vec2 sample_position = position.xz * 1.2;

    bool top_vertex = layout_texcoord.y < layout_midcoord.y;
    bool top_block = layout_material.x == 1010 || layout_material.x == 2003;

    vec3 wind = vec3(0);

    wind.x += sin(sample_position.y * 1.5 + sample_direction.x * 2) * 0.1;
    wind.z += sin(sample_position.x * 1.5 + sample_direction.y * 2) * 0.2;

    return wind * 0.45 * (tall ? mix(float(top_vertex) * 0.5, float(top_vertex) * 0.5 + 0.5, float(top_block)) : float(top_vertex));
}

vec3 leaves_animation(vec3 position){
    float time = frameTimeCounter * 1.3;

    vec3 sample_direction = time * vec3(-1, 0.5, 1);
    vec3 sample_position = position * 0.7;

    vec3 wind = vec3(0);

    wind.x += sin(sample_position.z * 1.5 + sample_direction.x * 2) * 0.1;
    wind.z += sin(sample_position.y * 1.5 + sample_direction.z * 2) * 0.2;
    wind.y += sin(sample_position.x * 2 + sample_direction.y * 3.5) * 0.06;

    return wind * 0.2;
}

vec3 fire_animation(vec3 position){
    float time = frameTimeCounter * 2.5;

    vec2 sample_direction = time * vec2(-1, 1);
    vec2 sample_noise = noise_fbm(position.xz * 0.7, sample_direction, time, 4);
    vec2 sample_position = position.xz * 0.5;

    bool top_vertex = layout_texcoord.y < layout_midcoord.y;
    bool top_block = layout_material.x == 1010;

    vec3 wind = vec3(0);

    wind.x += sin(sample_position.y * 1.5 + sample_direction.x * 2) * 0.7;
    wind.z += sin(sample_position.x * 1.5 + sample_direction.y * 2) * 0.8;

    return wind * 0.5 * float(top_vertex);
}

vec3 animation(vec3 position){
    position += cameraPosition;

    #ifdef WAVING_VEGETATION
        switch(int(layout_material.x)){
            case 1006:
            case 1007: 
            case 2001: position += grass_animation(position, false); break;

            case 1009:
            case 1010: 
            case 2002: 
            case 2003: position += grass_animation(position, true); break;

            case 1011:
            case 2004: position += leaves_animation(position); break;

            case 1018: position += fire_animation(position); break;
        }
    #endif

    return position - cameraPosition;
}