/*
    DRIVERS MACROS                                  GPU MACROS

    -MC_GL_RENDERER_RADEON                          -MC_GL_VENDOR_ATI
    -MC_GL_RENDERER_GEFORCE                         -MC_GL_VENDOR_INTEL
    -MC_GL_RENDERER_QUADRO                          -MC_GL_VENDOR_NVIDIA
    -MC_GL_RENDERER_INTEL
    -MC_GL_RENDERER_MESA

    LAYOUT 1.15+                                    LAYOUT 1.14.4 + LEGACY
    - 0 = gl_Position                               - 0 = gl_Position
    - 2 = gl_Normal                                 - 2 = gl_Normal;
    - 3 = gl_Color                                  - 3 = gl_Color
    - 8 = gl_MultiTexCoord0                         - 8 = gl_MultiTexCoord0
    - 10 = gl_MultiTexCoord2                        - 9 = gl_MultiTexCoord1
    - 11 = mc_Entity                                - 10 = mc_Entity
    - 12 = mc_midTexCoord                           - 11 = mc_midTexCoord
    - 13 = at_tangent                               - 12 = at_tangent
*/

#define texture2(x, y) texture2D(x, y)
#define texture3(x, y) texture3D(x, y)

#define texture2_lod(x, y, z) texture2DLod(x, y, z)
#define texture3_lod(x, y, z) texture3DLod(x, y, z)

#define texel_fetch(x, y) texelFetch2D(x, y, 0)
#define texel_fetch_lod(x, y, z) texelFetch2D(x, y, z)

#define texture_grad(x, y, d0, d1) texture2DGrad(x, y, d0, d1)

#if defined SHADERS_VERTEX
    #define layout_position gl_Vertex
    #define layout_normal gl_Normal
    #define layout_color gl_Color
    #define layout_texcoord gl_MultiTexCoord0
    #define layout_material mc_Entity
    #define layout_midcoord mc_midTexCoord
    #define layout_tangent at_tangent

    #if MC_VERSION > 11500
        #define layout_lightmap gl_MultiTexCoord2
    #elif MC_VERSION < 11500
        #define layout_lightmap gl_MultiTexCoord1
    #endif
#endif

const int noiseTextureResolution = 64;
const int shadowMapResolution = 2048;           //[1024 2048 3072 4096 6144 8192 10240 12288 14336 16384]

#if defined SHADERS_FRAGMENT
    #if defined COMPOSITE14
        //const float shadoDistances = 160;
        const float wetnessHalflife = 300;
        const float drynessHalflife = 300;
        const float ambientOcclusionLevel = 0.0;
        const float eyeBrightnessHalfLife = 10.0;

        const float sunPathRotation = -35;              //[-89 -88 -87 -86 -85 -84 -83 -82 -81 -80 -79 -78 -77 -76 -75 -74 -73 -72 -71 -70 -69 -68 -67 -66 -65 -64 -63 -62 -61 -60 -59 -58 -57 -56 -55 -54 -53 -52 -51 -50 -49 -48 -47 -46 -45 -44 -43 -42 -41 -40 -39 -38 -37 -36 -35 -34 -33 -32 -31 -30 -29 -28 -27 -26 -25 -24 -23 -22 -21 -20 -19 -18 -17 -16 -15 -14 -13 -12 -11 -10 -9 -8 -7 -6 -5 -4 -3 -2 -1 1 2 3 4 5 67 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89]

        /*
            const int colortex0Format = RGBA16F;            //Atmospheric scattering
            const int colortex1Format = RGBA16F;            //Atmospheric projection
            const int colortex2Format = RGBA16F;            //Atmospheric transmittance, bloom
            const int colortex3Format = RGBA16F;            //Water volumetric fog scattering
            const int colortex4Format = RGBA16F;            //Water volumetric fog transmittance
            const int colortex5Format = RGBA16F;            //Volumetric light
            //const int colortex6Format = RGBA16F;            //
            const int colortex7Format = RGBA16F;            //Current color
            const int colortex8Format = RGBA16F;            //Previous color
            const int colortex9Format = RGBA32UI;           //Albedo, normal, specular data, lightmap, id

            const int colortex10Format = RGBA16F;           //Global illumination, ambient occlusion
            const int colortex11Format = RGBA16F;           //Previous indirect light
            const int colortex12Format = RGBA16F;           //Clouds
            const int colortex13Format = RGBA16F;           //Clouds projection
            const int colortex14Format = RGBA16F;           //Rain particles, Enchantement albedo
            const int colortex15Format = RGBA16F;           //Previous depth, cloud shadow

            const int shadowcolor0Format = RGBA16;          //
            const int shadowcolor1Format = RGBA16;          //

            const bool colortex0Clear = false;
            const bool colortex1Clear = false;
            const bool colortex2Clear = false;
            const bool colortex3Clear = false;
            const bool colortex4Clear = false;
            const bool colortex5Clear = false;
            //const bool colortex6Clear = false;
            const bool colortex7Clear = false;
            const bool colortex8Clear = false;
            const bool colortex9Clear = true;

            const bool colortex10Clear = false;
            const bool colortex11Clear = false;
            const bool colortex12Clear = false;
            const bool colortex13Clear = false;
            const bool colortex14Clear = true;
            const bool colortex15Clear = false;

            const vec4 shadowcolor0ClearColor = vec4(0.0, 0.0, 0.0, 0.0);
            const vec4 shadowcolor1ClearColor = vec4(0.0, 0.0, 0.0, 0.0);
        */
    #endif
#endif