vec2 sincos(float x){
    return vec2(sin(x), cos(x));
}

vec2 sample_disk(float i, float n, int s){
    float t = (i + n) / float(s); 
    float r = tau * s;

    return sincos(t * r * golden_angle) * t;
}

vec2 location_disk(int i, float n, int c){
    float r = (i + n / 6.28) / c;
    float theta = r * 6.28 + n;

    return sincos(theta) * r;
}

vec2 fermats_spiral_n(float i, float t){
    return sincos(i * golden_angle) * sqrt(i / t);
}

vec3 generate_unit_vector(vec2 hash) {
    hash.x *= tau; hash.y = hash.y * 2.0 - 1.0;
    return vec3(vec2(sin(hash.x), cos(hash.x)) * sqrt(1.0 - hash.y * hash.y), hash.y);
}

vec3 generate_cone_vector(vec3 vector, vec2 xy, float angle) {
    vec3 dir = generate_unit_vector(xy);
    float noiseAngle = acos(dot(dir, vector)) * (angle / pi);

    return sin(noiseAngle) * normalize(cross(vector, dir)) + cos(noiseAngle) * vector;
}

float filter_gaussian(float x, float sigma){
    const float g = 1 / sqrt(tau * sigma * sigma);
    return (g * exp(-(x * x) / (2.0 * sigma * sigma)));
}

mat3 rotation_mat(vec3 x,vec3 y){
    float d = dot(x,y);
    vec3 cr = cross(y,x);
    
    float s = length(cr);
    
    float id = 1.-d;
    
    vec3 m = cr/s;
    
    vec3 m2 = m*m*id+d;
    vec3 sm = s*m;
    
    vec3 w = (m.xy*id).xxy*m.yzz;
    
    return mat3(
        m2.x,     w.x-sm.z, w.y+sm.y,
        w.x+sm.z, m2.y,     w.z-sm.x, 
        w.y-sm.y, w.z+sm.x, m2.z
    );
}

vec4 texture_bilinear(sampler2D sample_texture, vec2 coord){
    vec2 coord0 = coord + vec2(0, inverse_texel.y);
    vec2 coord1 = coord + vec2(inverse_texel.x, 0);
    vec2 coord2 = coord + vec2(inverse_texel.x, inverse_texel.y);
    vec2 coord3 = coord;

    vec4 s0 = texture(sample_texture, coord0);
    vec4 s1 = texture(sample_texture, coord1);
    vec4 s2 = texture(sample_texture, coord2);
    vec4 s3 = texture(sample_texture, coord3);

    vec2 uv = coord * texel;

    float fu = fract(uv.x);
    float fv = fract(uv.y);

    vec4 tmp0 = mix(s3, s1, fu);
    vec4 tmp1 = mix(s0, s2, fu);

    return mix(tmp0, tmp1, fv);
}

vec4 cubic(float x){
  float x2 = x * x;
  float x3 = x2 * x;

  vec4 w;
       w.x = -x3 + 3 * x2 - 3 * x + 1;
       w.y = 3 * x3 - 6 * x2 + 4;
       w.z = -3 * x3 + 3 * x2 + 3 * x + 1;
       w.w = x3;

  return w / 6.0;
}
//Neuhof
vec4 texture_bicubic(sampler2D sampler, vec2 coord){
  coord *= texel;

  vec2 f = vec2(fract(coord.x), fract(coord.y));

  coord -= f;

  f -= 0.5;

  vec4 cubicX = cubic(f.x);
  vec4 cubicY = cubic(f.y);

  vec4 c = vec4(coord.x - 0.5, coord.x + 1.5, coord.y - 0.5, coord.y + 1.5);
  vec4 s = vec4(cubicX.x + cubicX.y, cubicX.z + cubicX.w, cubicY.z + cubicY.y, cubicY.z + cubicY.w);
  vec4 offset = c + vec4(cubicX.y, cubicX.w, cubicY.y, cubicY.w) / s;

  vec4 tex0 = texture(sampler, vec2(offset.x, offset.z) * inverse_texel);
  vec4 tex1 = texture(sampler, vec2(offset.y, offset.z) * inverse_texel);
  vec4 tex2 = texture(sampler, vec2(offset.x, offset.w) * inverse_texel);
  vec4 tex3 = texture(sampler, vec2(offset.y, offset.w) * inverse_texel);

  float sx = s.x / (s.x + s.y);
  float sy = s.z / (s.z + s.w);

  return mix(mix(tex3, tex2, sx), mix(tex1, tex0, sy), sy);
}
