#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;

        #ifdef UPSIDE_DOWN_WORLD
            gl_Position = vec4(layout_position.xy * -2.0 + 1.0, 0.0, 1.0);
        #else
            gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
        #endif
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:0 */
    layout (location = 0) out vec4 buffers0;

    vec3 wide_screen(vec2 coord, vec3 color){
        #if WIDE_SCREEN == 1
            const float screen0 = 0.9 - WIDE_SCREEN_SIZE;
            const float screen1 = 0.1 + WIDE_SCREEN_SIZE;

            return coord.y > screen0 || coord.y < screen1 ? vec3(0) : color;
        #elif WIDE_SCREEN == 2

            const float screen0 = 0.69 - WIDE_SCREEN_SIZE;
            const float screen1 = 0.31 + WIDE_SCREEN_SIZE;

            return coord.x > screen0 || coord.x < screen1 ? vec3(0) : color;
        #elif WIDE_SCREEN == 0
            return color;
        #endif
    }

    vec3 vignette(vec2 coord, vec3 color){
        float dist = pow2(distance(coord, vec2(0.5))) * (1.14 + VIGNETTE_SIZE);

        #ifdef VIGNETTE
            return color * (1.0 - dist);
        #else
            return color;
        #endif
    }

    void fish_eye(inout vec2 coord){
        const float lens_radius = 16.0;
        const float sign_curvature = 10.0;

        float curvature = abs(sign_curvature);
        float optic = lens_radius / log2(curvature * lens_radius + 1.0) / 1.4427;

        vec2 xy = coord * vec2(1.5, 1.5);
        float radius = sqrt(xy.x * xy.x + xy.y * xy.y);

        float cos_angle = xy.x / radius;
        float sin_angle = xy.y / radius;

        float rad0 = (exp2((radius / optic) * 1.4427) - 1.0) / curvature;
        float rad1 = optic * log2(1.0 + curvature * radius) / 1.4427;

        float new_radius = sign_curvature > 0.0 ? rad0 : rad1;

        coord.x = new_radius * cos_angle + 0.5;
        coord.y = new_radius * sin_angle + 0.5;
    }

    void nether_heatwaves(inout vec2 coord){
        float depth = texture2(depthtex1, coord).x;
        
        vec2 offset = (fract(coord / noiseTextureResolution) * noiseTextureResolution) + sin(frameTimeCounter * 0.02);
        vec3 position = screen_to_viewspace(coord, depth);

        float dist = 1.0 - exp(-length(position) * 0.00022);

        #if defined NETHER_WORLD
            #ifdef NETHER_HEATWAVES
                coord.x += (texture2(noisetex, offset).x / 20.0) * dist;
                coord.y += (texture2(noisetex, offset).y / 20.0) * dist;
            #endif
        #endif
    }

    vec3 texture_sharpen(sampler2D tex, vec2 coord, vec2 t){
        temporal_settings ts = temporal_s();

        vec3 color = texture2(tex, coord).xyz;
        //vec3 color = texel_fetch(tex, ivec2(coord * texel)).xyz;
        //vec3 color = smaa_filter(tex, coord, texel);

        float color_avg = 0.0;
		float weight = 0.0;
		
        for(int i = -1; i <= 1; ++i){
            for(int j = -1; j <= 1; ++j){
                color_avg += luminance(texture2(tex, coord + vec2(i, j) * inverse_texel).xyz);
				weight += 1.0;
            }
        }
            
        color_avg /= weight;

        float sharpened_luminance = luminance(color) - color_avg;
        float final_luminance = luminance(color) + sharpened_luminance * ts.sharpen;

        #ifdef ADAPTIVE_SHARPEN
            color *= (final_luminance / luminance(color));
        #endif

        return color;
    }

    vec3 night_vision(vec2 coord, vec3 color){
        vec2 offset = coord * texel + sin(frame_16);
        vec3 noise = rand3(offset);
        
        float intensity = luminance(color);
              intensity = saturate(0.5 * (intensity - 0.5) + 0.5);

        vec3 green_color = vec3(0.0, intensity * 2.0, 0.0);

        #ifdef GREEN_NV
            return mix(color, (color + (noise * 0.2)) * green_color, nightVision);
        #else
            return color;
        #endif
    }

    vec3 blindness_effect(vec2 coord, vec3 color){
        float depth = texture2(depthtex0, coord).x;

        vec3 position = screen_to_viewspace(coord, depth);
        vec3 inverse_position = view_to_worldspace(position);

        float dist = 1.0 - exp2(-length(inverse_position) * 0.25 * blindness);

        return mix(color, vec3(0.0), dist);
    }

    vec3 damage_visual(vec3 color){
        #ifdef DAMAGE_VISUAL
            return color + (vec3(0.7, 0.0, 0.0) * damage);
        #else
            return color;
        #endif
    }

    void main(){
        vec2 offset = vertex_coord * texel + sin(frame_16);
        vec3 noise = rand3(offset) / 255.0;

        vec3 color = texture_sharpen(colortex0, vertex_coord, inverse_texel);
             color = damage_visual(color);
             color = blindness_effect(vertex_coord, color);
             color = night_vision(vertex_coord, color);
             color = wide_screen(vertex_coord, color);
             color = vignette(vertex_coord, color);

        buffers0.xyz = color + noise.x;
        buffers0.w = 1.0;
    }
#endif