#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:10 */
    layout (location = 0) out vec4 buffers0;

    #include "/program/shaders1/common/atmosphere/atmosphere.glsl"
    #include "/program/shaders1/common/indirect/rsm.glsl"
    #include "/program/shaders1/common/indirect/ao.glsl"

    void main(){
        const float lod = INDIRECT_LOD;

        vec2 coord = vertex_coord * lod;
        vec3 noise = blue_noise(vertex_coord).xyz;
        
        if(saturate(coord) == coord){
            gbuffers g = gbuffers_data(coord);
            specular s = specular_data(g.spec, g.albedo, g.id);
            space_position sp = position(coord, g.depth, false);
            materials m = material(g.depth, g.id);
            
            vec2 offset = vertex_coord * texel / lod;

            #ifdef GI
                vec3 gi = rsm(m, sp.inverse_position1, g.normal, noise.x, g.lightmap.y);
            #else
                vec3 gi = vec3(0.0);
            #endif

            #if AO == 0
                float ao = ssao(sp.position1, g.view_normal, noise.xy);
            #elif AO == 1
                float ao = rtao(sp.view_position1, sp.position1, g.normal, sp.inverse_vector1, noise.xy);
            #elif AO == 2
                float ao = ssao(sp.position1, g.view_normal, noise.xy) * rtao(sp.view_position1, sp.position1, g.normal, sp.inverse_vector1, noise.xy);
            #elif AO == 3
                float ao = 1.0;
            #endif

            buffers0.xyz = gi;
            buffers0.w = ao;
        }

        buffers0 = saturate_16(buffers0);
    }
#endif