#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        vertex_coord *= ATMOSPHERE_LOD;

        gl_Position = vec4(vertex_coord * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:0,12,13 */
    layout (location = 0) out vec4 buffers0;
    layout (location = 1) out vec4 buffers12;
    layout (location = 2) out vec4 buffers13;

    float remap(float value, float old_low, float old_high, float new_low, float new_high) {
        return  new_low + (value - old_low) * (new_high - new_low) / (old_high - old_low);
    }

    float hg_phase(float c, float g){
        return ((1.0 - g * g) / pow(1.0 + g * g - 2.0 * g * c, 1.5)) / (4.0 * pi);
    }

    float volumetric_clouds_phase(float theta, float c){
        const float g0 = 0.20;
        const float g1 = 0.15;

        float phase0 = hg_phase(theta, 0.5 * c);
		float phase1 = hg_phase(theta, 0.9 * c);
		float phase2 = hg_phase(theta, -0.5 * c);
		
		return mix(mix(phase0, phase2, g1), phase1, g0);
    }

    vec3 clouds_curvature(vec3 position){
        const float planet_radius = 6371e3;
        return vec3(position.x, length(position + vec3(0.0, planet_radius, 0.0)) - planet_radius, position.z);
    }

    #include "/program/shaders1/common/atmosphere/atmosphere.glsl"

    #include "/program/shaders1/common/volumetric/clouds_2D.glsl"
    #include "/program/shaders1/common/volumetric/clouds_3D.glsl"

    vec4 clouds_atmosphere(space_position sp, vec3 position, vec3 atmosphere, vec3 noise, const int steps){
        vec4 clouds = vec4(0.0, 0.0, 0.0, 1.0);

        #if defined VOLUMETRIC_CLOUD || defined PLANAR_CLOUD
            atmosphere = mix(atmosphere, atmosphere + atmosphere.g * 2.0, wetness);
        #endif

        #ifdef VOLUMETRIC_CLOUD
            vec4 clouds_3D = volumetric_clouds(position, sp.light_vector, sp.sun_vector, sp.moon_vector, noise, atmosphere);

            clouds.xyz += clouds_3D.xyz;
            clouds.w *= clouds_3D.w;
        #endif

        #ifdef PLANAR_CLOUD
            vec4 clouds_2D = planar_clouds(position, sp.light_vector, sp.sun_vector, sp.moon_vector, atmosphere);

            clouds.xyz += clouds_2D.xyz * clouds.w;
            clouds.w *= clouds_2D.w;
        #endif

        return clouds;
    }

    void main(){
        clouds_3D_settings vc = s_clouds3D();
        clouds_2D_settings pc = s_clouds2D();

        #if defined END_WORLD
            discard;
        #endif

        const float lod = ATMOSPHERE_LOD;

        vec2 coord = vertex_coord / lod;
        vec2 tile = (min(floor(texel.x * 0.5) / 1.5, floor(texel.y * 0.5)) * exp2(-CAPTURE_LOD)) * vec2(3.0, 2.0);
        vec3 noise = blue_noise(vertex_coord).xyz;
        
        if(clamp(coord, vec2(0.0), texel) == coord){
            gbuffers g = gbuffers_data(coord);
            space_position sp = position(coord, g.depth, false);
            
            vec3 transmittance = vec3(1.0);
            vec3 scattering = atmospheric_scattering(sp.inverse_vector1, sp.sun_vector, sp.moon_vector, 16, transmittance);
            vec3 atmosphere = texture2(colortex1, project_sphere(sp.inverse_vector1)).xyz;

            vec2 s_position = screen_velocity(sp.view_position1);
            vec2 velocity = coord - s_position;

            vec4 current = clouds_atmosphere(sp, sp.inverse_vector1, atmosphere, noise, vc.steps0);
            vec4 previous = texture2(colortex12, velocity * lod);

            float depth0 = length(coord);
            float depth1 = length(velocity);
			
			float lum0 = luminance(current.xyz);
			float lum1 = luminance(previous.xyz);

            float accumulation = exp2(-abs(depth0 - depth1) / depth0 * 12.0) * 0.7;

            float weight = saturate(velocity) != velocity ? 0.0 : 0.95 * accumulation;
				  //weight /= 1.0 - saturate(abs(lum0 - lum1) / lum0 * 12.0) * 0.1;
                  weight = saturate(weight);

            buffers0 = vec4(scattering, 0.0);
            buffers12 = mix(current, previous, weight);
        } else {
            buffers0 = vec4(0.0);
            buffers12 = vec4(0.0, 0.0, 0.0, 1.0);
        }

        if(gl_FragCoord.x < tile.x && gl_FragCoord.y < tile.y){
            gbuffers g = gbuffers_data(gl_FragCoord.xy * inverse_texel);
            space_position sp = position(gl_FragCoord.xy * inverse_texel, g.depth, false);

            vec3 position = unproject_sphere(gl_FragCoord.xy * inverse_texel);
                 position = normalize(position);

            vec3 atmosphere = texture2(colortex1, project_sphere(position)).xyz;

            buffers13 = clouds_atmosphere(sp, position, atmosphere, vec3(1.0), 4);
        } else {
            buffers13 = vec4(0.0, 0.0, 0.0, 1.0);
        }

        buffers0 = saturate_16(buffers0);
        buffers12 = saturate_16(buffers12);
        buffers13 = saturate_16(buffers13);
    }
#endif