bool screenspace_raytrace(vec3 view_position, vec3 position, vec3 direction, float NdotV, float noise, float z_treshold, int steps, inout vec3 hit_position){   
    direction = -position.z * direction;
    direction = normalize(view_to_screenspace(direction + position) - view_position);

    bool intersect = false;

    float max_length = 1.0 / float(steps);
    float min_length = 0.01 / float(steps);

    float ray_length = mix(min_length, max_length, NdotV) * (noise + 1.0);
    float ray_weight = 1.0 / direction.z;

    vec3 sample_increment = direction * ray_length;
    vec3 sample_position = view_position + sample_increment;

    float depth = texture2(depthtex1, sample_position.xy).x;

    for(int i = 0; i < steps; i++){
        if(saturate(sample_position) != sample_position) break;

        if(depth < sample_position.z){
            depth = texture2(depthtex1, sample_position.xy).x;

            float depth0 = linear_depth(sample_position.z);
            float depth1 = linear_depth(depth);

            float dist = abs(depth1 - depth0) / depth0;

            if(dist < z_treshold && depth0 > -far){
                hit_position = vec3(sample_position.xy, depth);
                intersect = true;
                break;
            }
        }

        ray_length = clamp(abs(depth - sample_position.z) * ray_weight, min_length, max_length);
        sample_position += direction * ray_length;
        depth = texture2(depthtex1, sample_position.xy).x;
    }

    if(depth >= 1.0) intersect = false;

    return intersect;
}