#include "/program/shaders1/common/shadow/shadow.glsl"
#include "/program/shaders1/common/indirect/skylight.glsl"

vec3 emissive(materials m, vec3 albedo, vec3 blocklight, float emissive){
     if(m.torch){
          return albedo * pi * pow3(length(albedo)) * blocklight;
     }

     if(m.redstone){
          return albedo * pi * pow2(length(albedo));
     }

     if(m.glowstone || m.fire){
          return albedo * pi * blocklight;
     }

     if(m.lava){
          #if defined NETHER_WORLD
               return albedo * 0.05 * blocklight;
          #else     
               return albedo * pi * blocklight;
          #endif
     }

     if(emissive < 255.0 - 254.0){
          return albedo * pow2(length(albedo)) * pi * emissive;
     }
}

float blocklight_falloff(float lightmap){
     float dist = 1.0 - lightmap;
           dist = pow(dist * 4.0 + 2.0, -2.0);

     return lightmap * dist;
}

float held_light(vec3 position, float NdotV, bool hand){
     float ID = heldItemId == 1001 || heldItemId == 1002 || heldItemId == 1003 || heldItemId == 1004 || heldItemId == 1005 || heldItemId == 1006 ? 1 : 0;

     float dist = pow2(length(position)) + 0.75;
           dist = 1.0 / dist;

     if(hand){
          NdotV = 1.0;
     }

     return dist * ID * NdotV;
}

float volumetric_clouds_shadow(vec3 position){
     clouds_3D_settings vc = s_clouds3D();

     vec3 shadow_position = mat3(shadowModelView) * position;
          shadow_position /= vc.distance;
          shadow_position *= 0.5 + 0.5;

     return texture2(colortex15, shadow_position.xy / (texel * vc.resolution)).y;
}

vec3 diffuse(gbuffers g, specular s, space_position sp, materials m, vec3 albedo, vec3 normal, vec3 view_position, mat2x3 position, mat2x3 vector, vec3 noise){
     const float emissive_brightness = 800.0 * (1.0 + BLOCKLIGHT_BRIGHTNESS);

     #if defined VOLUMETRIC_CLOUD && defined CLOUDS_SHADOW
          const float rain_brightness = 1.0;
     #else
          const float rain_brightness = mix(1.0, 0.0, wetness);
     #endif

     s.roughness = pow2(s.roughness);

     g.lightmap.x = saturate(g.lightmap.x * 1.1);
     g.lightmap.x = blocklight_falloff(g.lightmap.x);
     
     g.lightmap.y = saturate(g.lightmap.y);
     g.lightmap.y = 1.0 - pow(1.0 - g.lightmap.y, 0.5);
     g.lightmap.y = pow2(g.lightmap.y);

     float NdotL = dot(normal, sp.light_vector);
     float NdotV = max(1e-7, dot(normal, -vector[1]));
     float LdotV = length(sp.light_vector - vector[1]);
     float NdotH = (NdotL + NdotL) * inversesqrt(2.0 + 2.0 * LdotV);

     vec3 ggx = m.basic || m.textured || texture2(colortex14, vertex_coord).z == 1.0 ? vec3(0.0) : ggx_hightligh(s, m, albedo, normal, vector[1], sp.light_vector) * saturate(NdotL);
	 
	albedo *= 1.0 - s.f0;

     vec3 diffuse0 = hammon_diffuse(albedo, NdotL, NdotV, NdotH, LdotV, s.roughness) * saturate(NdotL);
     vec3 diffuse1 = hammon_diffuse(albedo, NdotV, NdotV, NdotV, 1.0, s.roughness);

     if(m.grass || m.leaves || m.fire){
          diffuse0 = hammon_diffuse(albedo, NdotV, NdotV, NdotV, 1.0, s.roughness) * 0.4;
     }

     if(m.textured){
          diffuse0 = vec3(0.4);
     }

     float ao = m.hand ? 1.0 : texture_bicubic(colortex11, vertex_coord).w;
     float contact = m.hand || m.textured || m.leaves ? 1.0 : screenspace_contact_shadow(m, view_position, position[0], sp.light_vector_view, noise.x);
     float clouds_shadow = volumetric_clouds_shadow(position[1]);

     vec3 sunlight = spherical_hamonics(ray_sh, sp.light_vector) * rain_brightness;
     vec3 skylight = spherical_hamonics(sky_sh, normal);

     vec3 blocklight = temperature_to_rgb(BLOCKLIGHT_TEMPERATURE);
     vec3 emissive = emissive(m, albedo, blocklight, s.emissive) * emissive_brightness;

     vec3 shadow = soft_shadow(m, position[1], noise, saturate(NdotL)) * contact * clouds_shadow;
     vec3 rsm = texture_bicubic(colortex11, vertex_coord).xyz;

     #if !defined DEFERRED7
          ggx *= rpi;
     #endif

     #if defined OVER_WORLD || defined END_WORLD
          vec3 direct = albedo * diffuse0 * sunlight;
               direct += ggx * sunlight;
               direct *= shadow;

          vec3 indirect = albedo * diffuse1 * skylight * g.lightmap.y * ao;
               indirect += albedo * blocklight * emissive_brightness * g.lightmap.x * ao;
               indirect += albedo * blocklight * held_light(position[1], NdotV, m.hand) * emissive_brightness;

          #if defined DEFERRED7
               indirect += albedo * rsm * sunlight * clouds_shadow;
          #endif
     #elif defined NETHER_WORLD
          vec3 direct = albedo * saturate(dot(normal, -vec3(0.0, 1.0, 0.0)));

          vec3 indirect = albedo * 1.1;
               indirect += albedo * blocklight * emissive_brightness * g.lightmap.x * ao;
               indirect += albedo * blocklight * held_light(position[1], NdotV, m.hand) * emissive_brightness;
     #endif

     return (direct + indirect + emissive) * mix(1.0, 0.1, blindness);
     //return vec3(0.0);
}