#if defined SHADERS_VERTEX
    out vec2 vertex_coord;
    out vec2 vertex_lightmap;
    out vec3 vertex_normal;
    out vec4 vertex_color;

    flat out float vertex_material;

    out vec3 position0;
    out vec3 position1;
    out vec3 position2;
    
    vec3 curvature(vec3 position){
        atmosphere_constant ac = atmosphere_s();

        position.yx *= rotation(position.x / ac.planet_radius);
        position.yz *= rotation(position.z / ac.planet_radius);

        return position;
    }

    void main(){
        vertex_material = layout_material.x;
        vertex_coord = layout_texcoord.xy;
        vertex_lightmap = layout_lightmap.xy / 255.0;
        vertex_normal = mat3(gbufferModelViewInverse) * (gl_NormalMatrix * layout_normal.xyz);
        vertex_color = layout_color;

        position0 = trans_mad(gl_ModelViewMatrix, layout_position.xyz);
        position1 = (trans_mad(gbufferModelViewInverse, position0));
        position2 = position1 + cameraPosition;

        gl_Position = trans_mad(gbufferModelView, position1).xyzz * diagonal4(gbufferProjection) + gbufferProjection[3];
        gl_Position.xy += jitter * gl_Position.w;
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;
    in vec2 vertex_lightmap;
    in vec3 vertex_normal;
    in vec4 vertex_color;

    flat in float vertex_material;

    in vec3 position0;
    in vec3 position1;
    in vec3 position2;

    /* RENDERTARGETS:14 */
    layout (location = 0) out vec4 buffers0;
    
    void main(){
        vec4 atlas0 = texture2(tex, vertex_coord) * vertex_color;

        if(atlas0.w < 0.128) discard;
        
        #if defined GBUFFERS_ENCHANT
            buffers0.xyz = atlas0.xyz;
            buffers0.w = 0.0;
        #else
            buffers0.xyz = vec3(0.0, 0.0, 1.0);
            buffers0.w = atlas0.w;
        #endif
    }
#endif