vec3 screen_to_viewspace(vec3 coord){
    coord = coord * 2 - 1;

    vec3 position = proj_mad(gbufferProjectionInverse, coord);
         position = position / (coord.z * gbufferProjectionInverse[2].w + gbufferProjectionInverse[3].w);

    return position;
}

vec3 screen_to_viewspace(vec2 coord, float depth){
    return screen_to_viewspace(vec3(coord, depth));
}

vec3 view_to_worldspace(vec3 position){
    return trans_mad(gbufferModelViewInverse, position);
}

vec3 view_to_screenspace(vec3 coord){
    return (proj_mad(gbufferProjection, coord) / -coord.z) * 0.5 + 0.5;
}

float projection_depth(float depth){
    return 1.0 / ((depth * 2.0 - 1.0) * gbufferProjectionInverse[2][3] + gbufferProjectionInverse[3][3]);
}

float linear_depth(float depth){
    return (2 * near) / (far + near - depth * (far - near));
}

vec2 screen_velocity(vec3 coord){
    vec3 position = screen_to_viewspace(coord);
    vec3 inversePosition = view_to_worldspace(position);

    vec3 projection = (cameraPosition - previousCameraPosition) + inversePosition;
         projection = trans_mad(gbufferPreviousModelView, projection);
         projection = proj_mad(gbufferPreviousProjection, projection) / -projection.z * 0.5 + 0.5;

    return coord.xy - projection.xy;
}

vec2 projection_velocity(vec3 coord){
    vec3 position = screen_to_viewspace(coord);
    vec3 inversePosition = view_to_worldspace(position);

    vec3 projection = (cameraPosition - previousCameraPosition) + inversePosition;
         projection = trans_mad(gbufferPreviousModelView, projection);
         projection = proj_mad(gbufferPreviousProjection, projection) / -projection.z * 0.5 + 0.5;

    return projection.xy;
}