vec3 world_to_shadowspace(vec3 position){
    vec3 shadow_position = trans_mad(shadowModelView, position);
         shadow_position = proj_mad(shadowProjection, shadow_position);
		 
    return shadow_position;
}

float distortion(shadow_settings s, vec2 position){    
    return length(position * 1.167) * s.distortion + (1.0 - s.distortion);
}

vec2 shadow_distortion(shadow_settings s, vec2 position){
    return position / distortion(s, position);
}

vec3 shadow_distortion(shadow_settings s, vec3 position){
    position.xy = shadow_distortion(s, position.xy);
    position.z *= s.depth;

    return position;
}