//Settings//
#include "/lib/common.glsl"

#ifdef FSH

//Varyings//
in vec2 texCoord;

#ifdef VL
in vec3 sunVec, upVec;
#endif

//Uniforms//
#if defined VL || defined VF_NETHER_END
uniform int isEyeInWater;
uniform int frameCounter;

uniform float far, near;
uniform float frameTimeCounter;
uniform float blindFactor;

#if MC_VERSION >= 11900
uniform float darknessFactor;
#endif

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;

#ifdef VL
uniform float timeAngle, timeBrightness, rainStrength;

uniform vec3 skyColor;
#endif
#endif

uniform sampler2D colortex0;

#if defined VL || defined VF_NETHER_END
uniform sampler2D noisetex;
uniform sampler2D colortex1;
uniform sampler2D depthtex0, depthtex1;

#ifdef VL
#ifdef SHADOW_COLOR
uniform sampler2D shadowcolor0;
#endif

uniform sampler2DShadow shadowtex0, shadowtex1;

uniform mat4 shadowModelView, shadowProjection;
#endif

uniform mat4 gbufferProjectionInverse, gbufferModelViewInverse;
#endif

//Common Variables//
#ifdef VL
float eBS = eyeBrightnessSmooth.y / 240.0;
float sunVisibility = clamp(dot(sunVec, upVec) + 0.025, 0.0, 0.1) * 10.0;
#endif

//Includes//
#if defined VL || defined VF_NETHER_END
#include "/lib/atmosphere/spaceConversion.glsl"
#include "/lib/util/ToView.glsl"
#include "/lib/util/ToWorld.glsl"
#include "/lib/color/dimensionColor.glsl"
#endif

#ifdef VL
#include "/lib/util/ToShadow.glsl"
#include "/lib/atmosphere/volumetricLight.glsl"
#endif

#ifdef VF_NETHER_END
#include "/lib/atmosphere/volumetricFog.glsl"
#endif

//Program//
void main() {
	vec3 color = pow(texture2D(colortex0, texCoord).rgb, vec3(2.2));
	vec3 vl = vec3(0.0);

	#if defined VL || defined VF_NETHER_END
	vec3 translucent = texture2D(colortex1, texCoord).rgb;

	float blueNoiseDither = texture2D(noisetex, gl_FragCoord.xy / 512.0).b;

	#ifdef TAA
	blueNoiseDither = fract(blueNoiseDither + frameCounter * 0.618);
	#endif

	#ifdef VL
	computeVolumetricLight(vl, translucent, blueNoiseDither);
	#endif

	#ifdef VF_NETHER_END
	computeVolumetricFog(vl, color, translucent, blueNoiseDither);
	#endif
	#endif

	/* DRAWBUFFERS:01 */
	gl_FragData[0].rgb = color;
	gl_FragData[1] = vec4(sqrt(vl), int(vl != vec3(0.0)));
}

#endif

/////////////////////////////////////////////////////////////////////////////////////

#ifdef VSH

//Varyings//
out vec2 texCoord;

#ifdef VL
out vec3 sunVec, upVec;
#endif

//Uniforms//
#ifdef VL
uniform float timeAngle;

uniform mat4 gbufferModelView;
#endif

//Program//
void main() {
	//Coord
	texCoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	
	//Sun Vector
	#ifdef VL
	const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
	float ang = fract(timeAngle - 0.25);
	ang = (ang + (cos(ang * PI) * -0.5 + 0.5 - ang) / 3.0) * TAU;
	sunVec = normalize((gbufferModelView * vec4(vec3(-sin(ang), cos(ang) * sunRotationData) * 2000.0, 1.0)).xyz);
	upVec = normalize(gbufferModelView[1].xyz);
	#endif

	//Position
	gl_Position = ftransform();
}


#endif