/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementItem;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.elements.ElementPageIconLink;

@SideOnly(value=Side.CLIENT)
public class ContentPageIconList
extends TinkerPage {
    protected final int width;
    protected final int height;
    public String title;
    public float maxScale = 2.5f;
    protected List<ElementPageIconLink> elements = Lists.newArrayList();

    public ContentPageIconList() {
        this(20);
    }

    public ContentPageIconList(int size) {
        this(size, size);
    }

    public ContentPageIconList(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean addLink(SizedBookElement element, String name, PageData pageData) {
        if (this.elements.size() >= this.getMaxIconCount()) {
            return false;
        }
        this.elements.add(new ElementPageIconLink(0, 0, element, name, pageData));
        return true;
    }

    public int getMaxIconCount() {
        return this.getMaxColumns() * this.getMaxRows();
    }

    public int getMaxRows() {
        return (GuiBook.PAGE_HEIGHT - (this.title != null ? 20 : 0)) / this.height;
    }

    public int getMaxColumns() {
        return (GuiBook.PAGE_WIDTH - 30) / this.width;
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int offset;
        int yOff = 0;
        if (this.title != null) {
            this.addTitle(list, this.title, false);
            yOff = 20;
        }
        int x = offset = 15;
        int y = yOff;
        int pageW = GuiBook.PAGE_WIDTH - 2 * offset;
        int pageH = GuiBook.PAGE_HEIGHT - yOff;
        float scale = this.maxScale;
        int scaledWidth = this.width;
        int scaledHeight = this.height;
        boolean fits = false;
        while (!fits && scale > 1.0f) {
            int cols;
            scaledWidth = (int)((float)this.width * (scale -= 0.25f));
            int rows = pageW / scaledWidth;
            fits = rows * (cols = pageH / (scaledHeight = (int)((float)this.height * scale))) >= this.elements.size();
        }
        for (ElementPageIconLink element : this.elements) {
            element.x = x;
            element.y = y;
            element.displayElement.x = x + (int)(scale * (float)(this.width - element.displayElement.width) / 2.0f);
            element.displayElement.y = y + (int)(scale * (float)(this.height - element.displayElement.height) / 2.0f);
            element.width = scaledWidth;
            element.height = scaledHeight;
            if (element.displayElement instanceof ElementItem) {
                ((ElementItem)element.displayElement).scale = scale;
            }
            list.add((BookElement)element);
            if ((x += scaledWidth) <= GuiBook.PAGE_WIDTH - offset - scaledWidth) continue;
            x = offset;
            if ((y += scaledHeight) <= GuiBook.PAGE_HEIGHT - scaledHeight) continue;
            break;
        }
    }

    public static List<ContentPageIconList> getPagesNeededForItemCount(int count, SectionData data, String title) {
        ArrayList listPages = Lists.newArrayList();
        while (count > 0) {
            ContentPageIconList overview = new ContentPageIconList();
            PageData page2 = new PageData(true);
            page2.source = data.source;
            page2.parent = data;
            page2.content = overview;
            page2.load();
            data.pages.add(page2);
            overview.title = title;
            listPages.add(overview);
            count -= overview.getMaxIconCount();
        }
        if (listPages.size() > 1) {
            listPages.forEach(page -> {
                page.maxScale = 1.0f;
            });
        }
        return listPages;
    }
}

