/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish.gui;

import java.util.function.Function;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.LongSliderEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.forge.impl.builders.SubCategoryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import troy.autofish.ForgeModAutofish;
import troy.autofish.config.Config;

public class AutofishScreenBuilder {
    private static final Function<Boolean, ITextComponent> yesNoTextSupplier = bool -> {
        if (bool.booleanValue()) {
            return AutofishScreenBuilder.text("\u00a7aOn");
        }
        return AutofishScreenBuilder.text("\u00a7eOff");
    };

    public static Screen buildScreen(ForgeModAutofish modAutofish, Minecraft client) {
        Config defaults = new Config();
        Config config = modAutofish.getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(client.field_71462_r).setTitle(AutofishScreenBuilder.text("Autofish Settings")).transparentBackground().setDoesConfirmSave(true).setSavingRunnable(() -> {
            modAutofish.getConfig().enforceConstraints();
            modAutofish.getConfigManager().writeConfig(true);
        });
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory configCat = builder.getOrCreateCategory(AutofishScreenBuilder.text("autofishconfig"));
        BooleanListEntry toggleAutofish = entryBuilder.startBooleanToggle(AutofishScreenBuilder.text("Enable Autofish"), config.isAutofishEnabled()).setDefaultValue(defaults.isAutofishEnabled()).setTooltip(new ITextComponent[]{AutofishScreenBuilder.text("Toggles the entire mod on or off.")}).setSaveConsumer(newValue -> modAutofish.getConfig().setAutofishEnabled((boolean)newValue)).setYesNoTextSupplier(yesNoTextSupplier).build();
        BooleanListEntry toggleMultiRod = entryBuilder.startBooleanToggle(AutofishScreenBuilder.text("Enable MultiRod"), config.isMultiRod()).setDefaultValue(defaults.isMultiRod()).setTooltip(new ITextComponent[]{AutofishScreenBuilder.text("Cycles through all of the"), AutofishScreenBuilder.text("available rods in the hotbar,"), AutofishScreenBuilder.text("moving to the next as they break.")}).setSaveConsumer(newValue -> modAutofish.getConfig().setMultiRod((boolean)newValue)).setYesNoTextSupplier(yesNoTextSupplier).build();
        BooleanListEntry toggleBreakProtection = entryBuilder.startBooleanToggle(AutofishScreenBuilder.text("Enable Break Protection"), config.isNoBreak()).setDefaultValue(defaults.isNoBreak()).setTooltip(new ITextComponent[]{AutofishScreenBuilder.text("Stop using rods with low"), AutofishScreenBuilder.text("durability before they break.")}).setSaveConsumer(newValue -> modAutofish.getConfig().setNoBreak((boolean)newValue)).setYesNoTextSupplier(yesNoTextSupplier).build();
        BooleanListEntry togglePersistentMode = entryBuilder.startBooleanToggle(AutofishScreenBuilder.text("Enable Persistent Mode"), config.isPersistentMode()).setDefaultValue(defaults.isPersistentMode()).setTooltip(new ITextComponent[]{AutofishScreenBuilder.text("Enable this to always keep the fish hook"), AutofishScreenBuilder.text("cast whenever a rod is in hand."), AutofishScreenBuilder.text("Checks every 10 seconds and recasts"), AutofishScreenBuilder.text("if needed."), AutofishScreenBuilder.text("This is useful for lag issues or when"), AutofishScreenBuilder.text("fishing for long periods of time.")}).setSaveConsumer(newValue -> modAutofish.getConfig().setPersistentMode((boolean)newValue)).setYesNoTextSupplier(yesNoTextSupplier).build();
        BooleanListEntry toggleSoundDetection = entryBuilder.startBooleanToggle(AutofishScreenBuilder.text("Use Sound Detection"), config.isUseSoundDetection()).setDefaultValue(defaults.isUseSoundDetection()).setTooltip(new ITextComponent[]{AutofishScreenBuilder.text("\u00a76Newer, more accurate detection based"), AutofishScreenBuilder.text("\u00a76on bobber sounds rather than the"), AutofishScreenBuilder.text("\u00a76standard hook movement detection."), AutofishScreenBuilder.text("-You must be somewhat close to the"), AutofishScreenBuilder.text("hook for this to work."), AutofishScreenBuilder.text("-If other players' hooks are near"), AutofishScreenBuilder.text("yours, it can falsely trigger a catch!"), AutofishScreenBuilder.text("\u00a7cNote: this option only affects"), AutofishScreenBuilder.text("\u00a7cmultiplayer. Singleplayer uses its own"), AutofishScreenBuilder.text("\u00a7cdetection.")}).setSaveConsumer(newValue -> {
            modAutofish.getConfig().setUseSoundDetection((boolean)newValue);
            modAutofish.getAutofish().setDetection();
        }).setYesNoTextSupplier(yesNoTextSupplier).build();
        LongSliderEntry recastDelaySlider = entryBuilder.startLongSlider(AutofishScreenBuilder.text("Recast Delay (ms)"), config.getRecastDelay(), 1000L, 5000L).setDefaultValue(defaults.getRecastDelay()).setTooltip(new ITextComponent[]{AutofishScreenBuilder.text("Adjusts the delay between catching"), AutofishScreenBuilder.text("a fish and recasting the rod.")}).setTextGetter(value -> AutofishScreenBuilder.text(value + " ms")).setSaveConsumer(newValue -> modAutofish.getConfig().setRecastDelay((long)newValue)).build();
        StringListEntry clearLagRegexField = entryBuilder.startTextField(AutofishScreenBuilder.text("ClearLag Chat Pattern"), config.getClearLagRegex()).setDefaultValue(defaults.getClearLagRegex()).setTooltip(new ITextComponent[]{AutofishScreenBuilder.text("Recast the fishing rod when"), AutofishScreenBuilder.text("this pattern is matched in chat."), AutofishScreenBuilder.text("\u00a76This pattern is a \u00a7aRegular Expression\u00a76.")}).setSaveConsumer(newValue -> modAutofish.getConfig().setClearLagRegex((String)newValue)).build();
        SubCategoryBuilder subCatBuilderBasic = entryBuilder.startSubCategory(AutofishScreenBuilder.text("Basic Options"));
        subCatBuilderBasic.add((AbstractConfigListEntry)toggleAutofish);
        subCatBuilderBasic.add((AbstractConfigListEntry)toggleMultiRod);
        subCatBuilderBasic.add((AbstractConfigListEntry)toggleBreakProtection);
        subCatBuilderBasic.add((AbstractConfigListEntry)togglePersistentMode);
        subCatBuilderBasic.setExpanded(true);
        SubCategoryBuilder subCatBuilderAdvanced = entryBuilder.startSubCategory(AutofishScreenBuilder.text("Advanced Options"));
        subCatBuilderAdvanced.add((AbstractConfigListEntry)toggleSoundDetection);
        subCatBuilderAdvanced.add((AbstractConfigListEntry)recastDelaySlider);
        subCatBuilderAdvanced.add((AbstractConfigListEntry)clearLagRegexField);
        subCatBuilderAdvanced.setExpanded(true);
        configCat.addEntry((AbstractConfigListEntry)subCatBuilderBasic.build());
        configCat.addEntry((AbstractConfigListEntry)subCatBuilderAdvanced.build());
        return builder.build();
    }

    private static ITextComponent text(String str) {
        return ITextComponent.func_241827_a_((String)str);
    }
}

