/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import troy.autofish.Autofish;
import troy.autofish.config.Config;
import troy.autofish.config.ConfigManager;
import troy.autofish.gui.AutofishScreenBuilder;
import troy.autofish.scheduler.AutofishScheduler;

@Mod(value="autofish")
public class ForgeModAutofish {
    private static ForgeModAutofish instance;
    private Autofish autofish;
    private AutofishScheduler scheduler;
    private KeyBinding autofishGuiKey;
    private ConfigManager configManager;

    public ForgeModAutofish() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::fmlClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void fmlClientSetup(FMLClientSetupEvent event) {
        if (instance == null) {
            instance = this;
        }
        this.configManager = new ConfigManager(this);
        this.autofishGuiKey = new KeyBinding("key.autofish.open_gui", 86, "Autofish");
        ClientRegistry.registerKeyBinding((KeyBinding)this.autofishGuiKey);
        this.scheduler = new AutofishScheduler(this);
        this.autofish = new Autofish(this);
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        Minecraft client = Minecraft.func_71410_x();
        if (this.autofishGuiKey.func_151468_f()) {
            client.func_147108_a(AutofishScreenBuilder.buildScreen(this, client));
        }
        this.autofish.tick(client);
        this.scheduler.tick(client);
    }

    public void handlePacket(IPacket<?> packet) {
        this.autofish.handlePacket(packet);
    }

    public void handleChat(SChatPacket packet) {
        this.autofish.handleChat(packet);
    }

    public void tickFishingLogic(Entity owner, int ticksCatchable) {
        this.autofish.tickFishingLogic(owner, ticksCatchable);
    }

    public static ForgeModAutofish getInstance() {
        return instance;
    }

    public Autofish getAutofish() {
        return this.autofish;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public Config getConfig() {
        return this.configManager.getConfig();
    }

    public AutofishScheduler getScheduler() {
        return this.scheduler;
    }
}

