/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.widget;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.LayoutManager;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.widget.Widget;
import java.util.List;

public abstract class Button
extends Widget {
    public String label;
    public Rectangle4i icon;
    public int state;

    public Button(String s) {
        this.label = s;
    }

    public Button() {
        this.label = "";
    }

    public int contentWidth() {
        return this.getRenderIcon() == null ? GuiDraw.getStringWidth((String)this.label) : this.getRenderIcon().w;
    }

    @Override
    public void draw(int mousex, int mousey) {
        LayoutManager.getLayoutStyle().drawButton(this, mousex, mousey);
    }

    @Override
    public boolean handleClick(int mx, int my, int button) {
        if ((button == 1 || button == 0) && this.onButtonPress(button == 1)) {
            NEIClientUtils.playClickSound();
        }
        return true;
    }

    public abstract boolean onButtonPress(boolean var1);

    public Rectangle4i getRenderIcon() {
        return this.icon;
    }

    @Override
    public void handleTooltip(int mx, int my, List<String> tooltip) {
        if (!this.contains(mx, my)) {
            return;
        }
        String tip = this.getButtonTip();
        if (tip != null) {
            tooltip.add(tip);
        }
    }

    public String getButtonTip() {
        return null;
    }

    public String getRenderLabel() {
        return this.label;
    }
}

