/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.lib.item.filtering.IItemFilter;
import codechicken.lib.item.filtering.IItemFilterProvider;
import codechicken.nei.ItemSorter;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.config.Option;
import codechicken.nei.layout.LayoutStyle;
import codechicken.nei.util.ItemInfo;
import codechicken.nei.util.ItemList;
import codechicken.nei.util.ItemStackSet;
import codechicken.nei.widget.SearchField;
import codechicken.nei.widget.SubsetWidget;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class API {
    public static void registerNEIGuiHandler(INEIGuiHandler handler) {
        GuiInfo.guiHandlers.add(handler);
    }

    public static void hideItem(ItemStack item) {
        ItemInfo.hiddenItems.add(item);
    }

    public static void setOverrideName(ItemStack item, String name) {
        ItemInfo.nameOverrides.put(item, name);
    }

    public static void addItemListEntry(ItemStack item) {
        ItemInfo.itemOverrides.put((Object)item.func_77973_b(), (Object)item);
    }

    public static void setItemListEntries(Item item, Iterable<ItemStack> items) {
        if (items == null) {
            items = Collections.emptyList();
        }
        ItemInfo.itemOverrides.replaceValues((Object)item, items);
    }

    public static void addOption(Option option) {
        NEIClientConfig.getOptionList().addOption(option);
    }

    public static void addLayoutStyle(int styleID, LayoutStyle style) {
        LayoutManager.layoutStyles.put(styleID, style);
    }

    public static void addFastTransferExemptSlot(Class<? extends Slot> slotClass) {
        ItemInfo.fastTransferExemptions.add(slotClass);
    }

    public static void addFastTransferExemptContainer(Class<? extends GuiContainer> guiClass) {
        ItemInfo.fastTransferContainerExemptions.add(guiClass);
    }

    public static void addItemFilter(IItemFilterProvider filterProvider) {
        ItemList.registerIItemFilterProvider(filterProvider);
    }

    public static void addSubset(String name, IItemFilter filter) {
        API.addSubset(new SubsetWidget.SubsetTag(name, filter));
    }

    public static void addSubset(String name, Iterable<ItemStack> items) {
        ItemStackSet filter = new ItemStackSet();
        for (ItemStack item : items) {
            filter.add(item);
        }
        API.addSubset(new SubsetWidget.SubsetTag(name, filter));
    }

    public static void addSubset(SubsetWidget.SubsetTag tag) {
        SubsetWidget.addTag(tag);
    }

    public static void addSearchProvider(SearchField.ISearchProvider provider) {
        SearchField.searchProviders.add(provider);
    }

    public static void addSortOption(String name, Comparator<ItemStack> comparator) {
        ItemSorter.add(name, comparator);
    }

    public static void addItemVariant(Item item, ItemStack variant) {
        ItemInfo.itemVariants.put((Object)item, (Object)variant);
    }
}

