/*
 * Decompiled with CFR 0.152.
 */
package com.TominoCZ.FBP;

import com.TominoCZ.FBP.block.FBPAnimationDummyBlock;
import com.TominoCZ.FBP.handler.FBPEventHandler;
import com.TominoCZ.FBP.handler.FBPGuiHandler;
import com.TominoCZ.FBP.handler.FBPKeyInputHandler;
import com.TominoCZ.FBP.keys.FBPKeyBindings;
import com.TominoCZ.FBP.particle.FBPParticleManager;
import com.google.common.base.Throwables;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SplittableRandom;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

@Mod(clientSideOnly=true, modid="fbp", acceptedMinecraftVersions="[1.12,1.13)")
public class FBP {
    @Mod.Instance(value="fbp")
    public static FBP INSTANCE;
    public static final String MODID = "fbp";
    public static final ResourceLocation LOCATION_PARTICLE_TEXTURE;
    public static final ResourceLocation FBP_BUG;
    public static final ResourceLocation FBP_FBP;
    public static final ResourceLocation FBP_WIDGETS;
    public static File animBlacklistFile;
    public static File particleBlacklistFile;
    public static File floatingMaterialsFile;
    public static File config;
    public static int minAge;
    public static int maxAge;
    public static int particlesPerAxis;
    public static double scaleMult;
    public static double gravityMult;
    public static double rotationMult;
    public static double weatherParticleDensity;
    public static boolean enabled;
    public static boolean showInMillis;
    public static boolean infiniteDuration;
    public static boolean randomRotation;
    public static boolean cartoonMode;
    public static boolean spawnWhileFrozen;
    public static boolean spawnRedstoneBlockParticles;
    public static boolean randomizedScale;
    public static boolean randomFadingSpeed;
    public static boolean entityCollision;
    public static boolean bounceOffWalls;
    public static boolean lowTraction;
    public static boolean smartBreaking;
    public static boolean fancyPlaceAnim;
    public static boolean animSmoothLighting;
    public static boolean spawnPlaceParticles;
    public static boolean fancyRain;
    public static boolean fancySnow;
    public static boolean fancyFlame;
    public static boolean fancySmoke;
    public static boolean waterPhysics;
    public static boolean restOnFloor;
    public static boolean frozen;
    public List<String> blockParticleBlacklist;
    public List<String> blockAnimBlacklist;
    public List<Material> floatingMaterials;
    public static SplittableRandom random;
    public static final Vec3d[] CUBE;
    public static final Vec3d[] CUBE_NORMALS;
    public static VertexFormat POSITION_TEX_COLOR_LMAP_NORMAL;
    public static MethodHandle setSourcePos;
    public static FBPAnimationDummyBlock FBPBlock;
    public static IRenderHandler fancyWeatherRenderer;
    public static IRenderHandler originalWeatherRenderer;
    public static FBPParticleManager fancyEffectRenderer;
    public static ParticleManager originalEffectRenderer;
    public FBPEventHandler eventHandler = new FBPEventHandler();
    public FBPGuiHandler guiHandler = new FBPGuiHandler();

    public FBP() {
        INSTANCE = this;
        POSITION_TEX_COLOR_LMAP_NORMAL = new VertexFormat();
        POSITION_TEX_COLOR_LMAP_NORMAL.func_181721_a(DefaultVertexFormats.field_181713_m);
        POSITION_TEX_COLOR_LMAP_NORMAL.func_181721_a(DefaultVertexFormats.field_181715_o);
        POSITION_TEX_COLOR_LMAP_NORMAL.func_181721_a(DefaultVertexFormats.field_181714_n);
        POSITION_TEX_COLOR_LMAP_NORMAL.func_181721_a(DefaultVertexFormats.field_181716_p);
        POSITION_TEX_COLOR_LMAP_NORMAL.func_181721_a(DefaultVertexFormats.field_181717_q);
        this.blockParticleBlacklist = Collections.synchronizedList(new ArrayList());
        this.blockAnimBlacklist = Collections.synchronizedList(new ArrayList());
        this.floatingMaterials = Collections.synchronizedList(new ArrayList());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        config = new File(evt.getModConfigurationDirectory() + "/FBP/Particle.properties");
        animBlacklistFile = new File(evt.getModConfigurationDirectory() + "/FBP/AnimBlockBlacklist.txt");
        particleBlacklistFile = new File(evt.getModConfigurationDirectory() + "/FBP/ParticleBlockBlacklist.txt");
        floatingMaterialsFile = new File(evt.getModConfigurationDirectory() + "/FBP/FloatingMaterials.txt");
        FBPKeyBindings.init();
        FMLCommonHandler.instance().bus().register((Object)new FBPKeyInputHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.eventHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this.guiHandler);
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            setSourcePos = lookup.unreflectSetter(ReflectionHelper.findField(ParticleDigging.class, (String[])new String[]{"field_181019_az", "sourcePos"}));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)FBPBlock);
    }

    public static boolean isEnabled() {
        boolean result = enabled;
        if (!result) {
            frozen = false;
        }
        return result;
    }

    public static void setEnabled(boolean enabled) {
        if (FBP.enabled != enabled) {
            if (enabled) {
                fancyEffectRenderer.carryOver();
                Minecraft.func_71410_x().field_71452_i = fancyEffectRenderer;
                Minecraft.func_71410_x().field_71441_e.field_73011_w.setWeatherRenderer(fancyWeatherRenderer);
            } else {
                Minecraft.func_71410_x().field_71452_i = originalEffectRenderer;
                Minecraft.func_71410_x().field_71441_e.field_73011_w.setWeatherRenderer(originalWeatherRenderer);
            }
        }
        FBP.enabled = enabled;
    }

    public static boolean isDev() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    public boolean isBlacklisted(Block b, boolean particle) {
        if (b == null) {
            return true;
        }
        return (particle ? this.blockParticleBlacklist : this.blockAnimBlacklist).contains(b.getRegistryName().toString());
    }

    public boolean doesMaterialFloat(Material mat) {
        return this.floatingMaterials.contains(mat);
    }

    public void addToBlacklist(Block b, boolean particle) {
        String name;
        if (b == null) {
            return;
        }
        if (!(particle ? this.blockParticleBlacklist : this.blockAnimBlacklist).contains(name = b.getRegistryName().toString())) {
            (particle ? this.blockParticleBlacklist : this.blockAnimBlacklist).add(name);
        }
    }

    public void removeFromBlacklist(Block b, boolean particle) {
        String name;
        if (b == null) {
            return;
        }
        if ((particle ? this.blockParticleBlacklist : this.blockAnimBlacklist).contains(name = b.getRegistryName().toString())) {
            (particle ? this.blockParticleBlacklist : this.blockAnimBlacklist).remove(name);
        }
    }

    public void addToBlacklist(String name, boolean particle) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        for (ResourceLocation rl : Block.field_149771_c.func_148742_b()) {
            String s = rl.toString();
            if (!s.equals(name)) continue;
            Block b = (Block)Block.field_149771_c.func_82594_a((Object)rl);
            if (b == Blocks.field_150451_bX) break;
            this.addToBlacklist(b, particle);
            break;
        }
    }

    public void resetBlacklist(boolean particle) {
        if (particle) {
            this.blockParticleBlacklist.clear();
        } else {
            this.blockAnimBlacklist.clear();
        }
    }

    static {
        LOCATION_PARTICLE_TEXTURE = new ResourceLocation("textures/particle/particles.png");
        FBP_BUG = new ResourceLocation("fbp:textures/gui/bug.png");
        FBP_FBP = new ResourceLocation("fbp:textures/gui/fbp.png");
        FBP_WIDGETS = new ResourceLocation("fbp:textures/gui/widgets.png");
        animBlacklistFile = null;
        particleBlacklistFile = null;
        floatingMaterialsFile = null;
        config = null;
        enabled = true;
        showInMillis = false;
        infiniteDuration = false;
        random = new SplittableRandom();
        CUBE = new Vec3d[]{new Vec3d(1.0, 1.0, -1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(-1.0, 1.0, 1.0), new Vec3d(-1.0, 1.0, -1.0), new Vec3d(-1.0, -1.0, -1.0), new Vec3d(-1.0, -1.0, 1.0), new Vec3d(1.0, -1.0, 1.0), new Vec3d(1.0, -1.0, -1.0), new Vec3d(-1.0, -1.0, 1.0), new Vec3d(-1.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, -1.0, 1.0), new Vec3d(1.0, -1.0, -1.0), new Vec3d(1.0, 1.0, -1.0), new Vec3d(-1.0, 1.0, -1.0), new Vec3d(-1.0, -1.0, -1.0), new Vec3d(-1.0, -1.0, -1.0), new Vec3d(-1.0, 1.0, -1.0), new Vec3d(-1.0, 1.0, 1.0), new Vec3d(-1.0, -1.0, 1.0), new Vec3d(1.0, -1.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 1.0, -1.0), new Vec3d(1.0, -1.0, -1.0)};
        CUBE_NORMALS = new Vec3d[]{new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, -1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, -1.0), new Vec3d(-1.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 0.0)};
        FBPBlock = new FBPAnimationDummyBlock();
    }
}

