/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util;

import greymerk.roguelike.util.IWeighted;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedRandomizer<T>
implements IWeighted<T> {
    private int weight;
    private int weightSum;
    private List<IWeighted<T>> items;

    public WeightedRandomizer(int weight) {
        this.weight = weight;
        this.weightSum = 0;
        this.items = new ArrayList<IWeighted<T>>();
    }

    public WeightedRandomizer(WeightedRandomizer<T> toCopy) {
        this.weight = toCopy.weight;
        this.weightSum = toCopy.weightSum;
        this.items = new ArrayList<IWeighted<T>>();
        for (IWeighted<T> e : toCopy.items) {
            this.items.add(e);
        }
    }

    public WeightedRandomizer(WeightedRandomizer<T> base, WeightedRandomizer<T> other) {
        this();
        for (IWeighted<T> item : base.items) {
            this.add(item);
        }
        for (IWeighted<T> item : other.items) {
            this.add(item);
        }
    }

    public WeightedRandomizer() {
        this(0);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void add(IWeighted<T> toAdd) {
        this.weightSum += toAdd.getWeight();
        this.items.add(toAdd);
    }

    @Override
    public T get(Random rand) {
        if (this.weightSum == 0) {
            return null;
        }
        if (this.items.isEmpty()) {
            return null;
        }
        int roll = rand.nextInt(this.weightSum);
        for (IWeighted<T> i : this.items) {
            if ((roll -= i.getWeight()) >= 0) continue;
            return i.get(rand);
        }
        return null;
    }

    public void merge(WeightedRandomizer<T> toMerge) {
        for (IWeighted<T> item : toMerge.items) {
            this.add(item);
        }
    }
}

