/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.ISettingsContainer;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsBlank;
import greymerk.roguelike.dungeon.settings.SettingsRandom;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Collection;
import java.util.Random;

public class SettingsResolver {
    private ISettingsContainer settings;

    public SettingsResolver(ISettingsContainer settings) throws Exception {
        this.settings = settings;
    }

    public ISettings getSettings(IWorldEditor editor, Random rand, Coord pos) throws Exception {
        if (RogueConfig.getBoolean(RogueConfig.RANDOM)) {
            return new SettingsRandom(rand);
        }
        DungeonSettings builtin = this.getBuiltin(editor, rand, pos);
        DungeonSettings custom = this.getCustom(editor, rand, pos);
        if (builtin == null && custom == null) {
            return null;
        }
        DungeonSettings exclusive = custom != null ? custom : builtin;
        DungeonSettings complete = this.applyInclusives(exclusive, editor, rand, pos);
        return complete;
    }

    public ISettings getWithName(String name, IWorldEditor editor, Random rand, Coord pos) throws Exception {
        if (name.equals("random")) {
            return new SettingsRandom(rand);
        }
        DungeonSettings byName = this.getByName(name);
        if (byName == null) {
            return null;
        }
        DungeonSettings withInclusives = this.applyInclusives(byName, editor, rand, pos);
        return new DungeonSettings(new SettingsBlank(), withInclusives);
    }

    public static DungeonSettings processInheritance(DungeonSettings toProcess, ISettingsContainer settings) throws Exception {
        DungeonSettings setting = new SettingsBlank();
        if (toProcess == null) {
            throw new Exception("Process Inheritance called with null settings object");
        }
        for (SettingIdentifier id : toProcess.getInherits()) {
            if (settings.contains(id)) {
                DungeonSettings inherited = new DungeonSettings(settings.get(id));
                if (!inherited.getInherits().isEmpty()) {
                    inherited = SettingsResolver.processInheritance(inherited, settings);
                }
                setting = new DungeonSettings(setting, inherited);
                continue;
            }
            throw new Exception("Setting not found: " + id.toString());
        }
        return new DungeonSettings(setting, toProcess);
    }

    public ISettings getDefaultSettings() {
        return new DungeonSettings(this.settings.get(new SettingIdentifier("builtin", "base")));
    }

    private DungeonSettings getByName(String name) throws Exception {
        SettingIdentifier id;
        try {
            id = new SettingIdentifier(name);
        }
        catch (Exception e) {
            throw new Exception("Malformed Setting ID String: " + name);
        }
        if (!this.settings.contains(id)) {
            return null;
        }
        DungeonSettings setting = new DungeonSettings(this.settings.get(id));
        return SettingsResolver.processInheritance(setting, this.settings);
    }

    private DungeonSettings getBuiltin(IWorldEditor editor, Random rand, Coord pos) throws Exception {
        if (!RogueConfig.getBoolean(RogueConfig.SPAWNBUILTIN)) {
            return null;
        }
        WeightedRandomizer<DungeonSettings> settingsRandomizer = new WeightedRandomizer<DungeonSettings>();
        for (DungeonSettings setting : this.settings.getBuiltinSettings()) {
            if (!setting.isValid(editor, pos)) continue;
            settingsRandomizer.add(new WeightedChoice<DungeonSettings>(setting, setting.criteria.weight));
        }
        if (settingsRandomizer.isEmpty()) {
            return new SettingsBlank();
        }
        DungeonSettings chosen = (DungeonSettings)settingsRandomizer.get(rand);
        return SettingsResolver.processInheritance(chosen, this.settings);
    }

    private DungeonSettings getCustom(IWorldEditor editor, Random rand, Coord pos) throws Exception {
        WeightedRandomizer<DungeonSettings> settingsRandomizer = new WeightedRandomizer<DungeonSettings>();
        for (DungeonSettings setting : this.settings.getCustomSettings()) {
            if (!setting.isValid(editor, pos) || !setting.isExclusive()) continue;
            settingsRandomizer.add(new WeightedChoice<DungeonSettings>(setting, setting.criteria.weight));
        }
        DungeonSettings chosen = (DungeonSettings)settingsRandomizer.get(rand);
        if (chosen == null) {
            return null;
        }
        return SettingsResolver.processInheritance(chosen, this.settings);
    }

    private DungeonSettings applyInclusives(DungeonSettings setting, IWorldEditor editor, Random rand, Coord pos) throws Exception {
        DungeonSettings toReturn = new DungeonSettings(setting);
        for (DungeonSettings s : this.settings.getCustomSettings()) {
            if (!s.isValid(editor, pos) || s.isExclusive()) continue;
            toReturn = new DungeonSettings(toReturn, SettingsResolver.processInheritance(s, this.settings));
        }
        return toReturn;
    }

    public String toString(String namespace) {
        Collection<DungeonSettings> byNamespace = this.settings.getByNamespace(namespace);
        if (byNamespace.isEmpty()) {
            return "";
        }
        String toReturn = "";
        for (DungeonSettings setting : byNamespace) {
            toReturn = toReturn + setting.id.toString() + " ";
        }
        return toReturn;
    }

    public String toString() {
        return this.settings.toString();
    }
}

