/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.IDungeonFactory;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;

public class DungeonFactory
implements IDungeonFactory {
    private Map<DungeonRoom, Integer> singles = new HashMap<DungeonRoom, Integer>();
    private Map<DungeonRoom, Integer> multiple = new HashMap<DungeonRoom, Integer>();
    private DungeonRoom base;
    private Iterator<IDungeonRoom> singleRooms;

    public DungeonFactory() {
        this(DungeonRoom.CORNER);
    }

    public DungeonFactory(DungeonRoom base) {
        this.base = base;
    }

    public DungeonFactory(JsonArray json) throws Exception {
        this();
        for (JsonElement e : json) {
            this.add(e.getAsJsonObject());
        }
    }

    public DungeonFactory(DungeonFactory toCopy) {
        this();
        for (DungeonRoom room : toCopy.singles.keySet()) {
            this.singles.put(room, toCopy.singles.get((Object)room));
        }
        for (DungeonRoom room : toCopy.multiple.keySet()) {
            this.multiple.put(room, toCopy.multiple.get((Object)room));
        }
        this.base = toCopy.base;
    }

    public DungeonFactory(DungeonFactory base, DungeonFactory other) {
        this();
        this.base = other.base;
        if (other.singles.keySet().isEmpty()) {
            for (DungeonRoom room : base.singles.keySet()) {
                this.singles.put(room, base.singles.get((Object)room));
            }
        } else {
            for (DungeonRoom room : other.singles.keySet()) {
                this.singles.put(room, other.singles.get((Object)room));
            }
        }
        if (other.multiple.keySet().isEmpty()) {
            for (DungeonRoom room : base.multiple.keySet()) {
                this.multiple.put(room, base.multiple.get((Object)room));
            }
        } else {
            for (DungeonRoom room : other.multiple.keySet()) {
                this.multiple.put(room, other.multiple.get((Object)room));
            }
        }
    }

    public void add(JsonObject entry) throws Exception {
        int weight;
        String mode = entry.get("type").getAsString().toLowerCase();
        String type = entry.get("name").getAsString().toUpperCase();
        int n = weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
        if (!DungeonRoom.contains(type)) {
            throw new Exception("No such dungeon: " + type);
        }
        DungeonRoom toAdd = DungeonRoom.valueOf(entry.get("name").getAsString());
        if (mode.equals("single")) {
            this.addSingle(toAdd);
        }
        if (mode.equals("random")) {
            this.addRandom(toAdd, weight);
        }
    }

    @Override
    public IDungeonRoom get(Random rand) {
        if (this.singleRooms == null) {
            this.singleRooms = new RoomIterator();
        }
        if (this.singleRooms.hasNext()) {
            return this.singleRooms.next();
        }
        Set<DungeonRoom> keyset = this.multiple.keySet();
        if (keyset.isEmpty()) {
            return DungeonRoom.getInstance(this.base);
        }
        WeightedRandomizer<DungeonRoom> randomizer = new WeightedRandomizer<DungeonRoom>();
        for (DungeonRoom room : keyset) {
            randomizer.add(new WeightedChoice<DungeonRoom>(room, this.multiple.get((Object)room)));
        }
        DungeonRoom choice = (DungeonRoom)((Object)randomizer.get(rand));
        return DungeonRoom.getInstance(choice);
    }

    public void addSingle(DungeonRoom type) {
        this.addSingle(type, 1);
    }

    public void addSingle(DungeonRoom type, int num) {
        if (!this.singles.containsKey((Object)type)) {
            this.singles.put(type, num);
            return;
        }
        int count = this.singles.get((Object)type);
        this.singles.put(type, count += num);
    }

    public void addRandom(DungeonRoom type, int weight) {
        this.multiple.put(type, weight);
    }

    public boolean equals(Object o) {
        DungeonFactory other = (DungeonFactory)o;
        if (!this.base.equals((Object)other.base)) {
            return false;
        }
        if (!this.singles.equals(other.singles)) {
            return false;
        }
        return this.multiple.equals(other.multiple);
    }

    public static DungeonFactory getRandom(Random rand, int numRooms) {
        DungeonFactory rooms = new DungeonFactory();
        rooms.base = DungeonRoom.CORNER;
        for (int i = 0; i < numRooms; ++i) {
            DungeonRoom type = DungeonRoom.getRandomRoom(rand);
            if (rand.nextBoolean()) {
                rooms.addRandom(type, 1);
                continue;
            }
            rooms.addSingle(type, 1);
        }
        return rooms;
    }

    private class RoomIterator
    implements Iterator<IDungeonRoom> {
        private PriorityQueue<IDungeonRoom> rooms = new PriorityQueue();

        public RoomIterator() {
            Set keyset = DungeonFactory.this.singles.keySet();
            for (DungeonRoom type : keyset) {
                for (int i = 0; i < (Integer)DungeonFactory.this.singles.get((Object)type); ++i) {
                    this.rooms.add(DungeonRoom.getInstance(type));
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !this.rooms.isEmpty();
        }

        @Override
        public IDungeonRoom next() {
            return this.rooms.poll();
        }
    }
}

