/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.ILevelGenerator;
import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.LevelLayout;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.IDungeonFactory;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.filter.Filter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class DungeonGenerator {
    public static final int VERTICAL_SPACING = 10;
    public static final int TOPLEVEL = 50;
    private Coord origin;
    private List<IDungeonLevel> levels = new ArrayList<IDungeonLevel>();

    public void generate(IWorldEditor editor, ISettings settings, Coord pos) {
        Iterator<DungeonTunnel> layout;
        this.origin = new Coord(pos.getX(), 50, pos.getZ());
        Coord start = new Coord(this.origin);
        Random rand = Dungeon.getRandom(editor, start);
        int numLevels = settings.getNumLevels();
        for (int i = 0; i < numLevels; ++i) {
            LevelSettings levelSettings = settings.getLevelSettings(i);
            IDungeonLevel level = new DungeonLevel(editor, rand, levelSettings, new Coord(start));
            this.levels.add(level);
        }
        for (IDungeonLevel level : this.levels) {
            ILevelGenerator generator = LevelGenerator.getGenerator(editor, rand, level.getSettings().getGenerator(), level);
            try {
                level.generate(generator, start);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LevelLayout layout2 = generator.getLayout();
            rand = Dungeon.getRandom(editor, start);
            start = new Coord(layout2.getEnd().getPosition());
            start.add(Cardinal.DOWN, 10);
        }
        for (IDungeonLevel level : this.levels) {
            layout = level.getLayout();
            IDungeonFactory rooms = level.getSettings().getRooms();
            int count = 0;
            while (((LevelLayout)((Object)layout)).hasEmptyRooms()) {
                IDungeonRoom toGenerate = count < level.getSettings().getNumRooms() ? rooms.get(rand) : DungeonRoom.getInstance(DungeonRoom.CORNER);
                DungeonNode node = ((LevelLayout)((Object)layout)).getBestFit(toGenerate);
                node.setDungeon(toGenerate);
                ++count;
            }
        }
        if (RogueConfig.getBoolean(RogueConfig.ENCASE)) {
            for (IDungeonLevel level : this.levels) {
                level.filter(editor, rand, Filter.get(Filter.ENCASE));
            }
        }
        for (IDungeonLevel level : this.levels) {
            for (DungeonTunnel t : level.getLayout().getTunnels()) {
                t.construct(editor, rand, level.getSettings());
            }
        }
        for (IDungeonLevel level : this.levels) {
            layout = level.getLayout();
            List<DungeonNode> nodes = ((LevelLayout)((Object)layout)).getNodes();
            DungeonNode startRoom = ((LevelLayout)((Object)layout)).getStart();
            DungeonNode endRoom = ((LevelLayout)((Object)layout)).getEnd();
            for (DungeonNode node : nodes) {
                if (node == startRoom || node == endRoom) continue;
                IDungeonRoom toGenerate = node.getRoom();
                toGenerate.generate(editor, rand, level.getSettings(), node.getEntrances(), node.getPosition());
            }
        }
        for (IDungeonLevel level : this.levels) {
            for (DungeonTunnel tunnel : level.getLayout().getTunnels()) {
                tunnel.genSegments(editor, rand, level);
            }
        }
        IDungeonLevel previous = null;
        for (IDungeonLevel level : this.levels) {
            DungeonNode upper = previous == null ? null : previous.getLayout().getEnd();
            DungeonNode lower = level.getLayout().getStart();
            LevelGenerator.generateLevelLink(editor, rand, level.getSettings(), lower, upper);
            previous = level;
        }
        this.tower(editor, settings, this.origin);
    }

    private void tower(IWorldEditor editor, ISettings settings, Coord pos) {
        Tower tower = settings.getTower().getTower();
        Random rand = Dungeon.getRandom(editor, new Coord(pos));
        Tower.get(tower).generate(editor, rand, settings.getTower().getTheme(), new Coord(pos));
    }

    public List<IDungeonLevel> getLevels() {
        return this.levels;
    }

    public boolean isGenerated() {
        return this.origin != null;
    }

    public Coord getPosition() {
        if (!this.isGenerated()) {
            return null;
        }
        return new Coord(this.origin);
    }

    public void applyFilters(IWorldEditor editor, Random rand) {
        for (IDungeonLevel level : this.levels) {
            level.applyFilters(editor, rand);
        }
    }
}

