/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.passive.mountable;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.entities.util.EntityMountable;
import com.legacy.aether.items.ItemsAether;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntitySwet
extends EntityMountable
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Integer> ATTACK_COOLDOWN = EntityDataManager.func_187226_a(EntitySwet.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean isFriendly;
    private int swetType;
    private int slimeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
    public int ticker = 0;
    public int flutter = 0;
    public int hops = 0;
    public boolean kickoff;

    public EntitySwet(World world) {
        super(world);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_70606_j(25.0f);
        this.setType(this.field_70146_Z.nextInt(2));
        this.func_70105_a(0.8f, 0.8f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.5);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.swetType);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.swetType = buffer.readInt();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_COOLDOWN, (Object)100);
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.hasPrey() && this.kickoff) {
            this.setAttackCooldown(50);
            ((Entity)this.func_184188_bt().get(0)).func_184210_p();
            this.kickoff = false;
        }
    }

    @Override
    public void func_70071_h_() {
        Entity entity;
        List list;
        if (this.func_70638_az() != null) {
            for (int i = 0; i < 3; ++i) {
                double d = (float)this.field_70165_t + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
                double d1 = (float)this.field_70163_u + this.field_70131_O;
                double d2 = (float)this.field_70161_v + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d, d1 - 0.25, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        super.func_70071_h_();
        if (this.getAttackCooldown() != 0) {
            this.setAttackCooldown(this.getAttackCooldown() - 1);
        }
        if (this.getAttackCooldown() == 0 && !this.hasPrey() && !this.isFriendly() && 0 < (list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())).size() && (entity = (Entity)list.get(0)) instanceof EntityLivingBase && !(entity instanceof EntitySwet)) {
            this.capturePrey((EntityLivingBase)entity);
        }
        if (this.func_70072_I()) {
            this.dissolve();
        }
    }

    protected boolean func_70692_ba() {
        return !this.isFriendly();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isFriendly()) {
            return;
        }
        super.func_180430_e(distance, damageMultiplier);
        if (this.hops >= 3 && this.func_110143_aJ() > 0.0f) {
            this.dissolve();
        }
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        if (!this.hasPrey()) {
            super.func_70653_a(entityIn, strength, xRatio, zRatio);
        }
    }

    @Override
    public void updateRider() {
        if (this.isFriendly() && this.func_184207_aI()) {
            Entity passenger = (Entity)this.func_184188_bt().get(0);
            if (passenger.func_70093_af()) {
                this.setAttackCooldown(50);
                passenger.func_184210_p();
            } else {
                this.setRiderSneaking(false);
            }
            passenger.func_70095_a(false);
        }
    }

    public void dissolve() {
        for (int i = 0; i < 50; ++i) {
            float f = this.field_70146_Z.nextFloat() * 3.141593f * 2.0f;
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.25f;
            float f2 = MathHelper.func_76126_a((float)f) * f1;
            float f3 = MathHelper.func_76134_b((float)f) * f1;
            this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f2, this.func_174813_aQ().field_72338_b + 1.25, this.field_70161_v + (double)f3, (double)f2 * 1.5 + this.field_70159_w, 4.0, (double)f3 * 1.5 + this.field_70179_y, new int[0]);
        }
        this.func_70106_y();
    }

    public void capturePrey(EntityLivingBase entity) {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187870_fk, SoundCategory.HOSTILE, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f, false);
        this.field_70169_q = this.field_70165_t = entity.field_70165_t;
        this.field_70167_r = this.field_70163_u = entity.field_70163_u + (double)0.01f;
        this.field_70166_s = this.field_70161_v = entity.field_70161_v;
        this.field_70126_B = this.field_70177_z = entity.field_70177_z;
        this.field_70127_C = this.field_70125_A = entity.field_70125_A;
        this.field_70159_w = entity.field_70159_w;
        this.field_70181_x = entity.field_70181_x;
        this.field_70179_y = entity.field_70179_y;
        this.setAttackCooldown(50);
        this.func_70105_a(entity.field_70130_N, entity.field_70131_O);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entity.func_184220_m((Entity)this);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityLivingBase entityliving;
        boolean flag;
        Entity entity = source.func_76364_f();
        if (this.hops == 3 && entity == null && this.func_110143_aJ() >= 1.0f) {
            this.func_70606_j(1.0f);
        }
        if ((flag = super.func_70097_a(source, amount)) && this.hasPrey()) {
            EntityLivingBase rider = (EntityLivingBase)this.func_184188_bt().get(0);
            if (entity != null && this.isPrey(entity)) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.kickoff = true;
                }
            } else {
                rider.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), amount);
                if (this.func_110143_aJ() <= 0.0f) {
                    this.kickoff = true;
                }
            }
        }
        if (flag && this.func_110143_aJ() <= 0.0f) {
            this.dissolve();
        } else if (flag && entity instanceof EntityLivingBase && (entityliving = (EntityLivingBase)entity).func_110143_aJ() >= 0.0f && this.isPrey((Entity)entityliving)) {
            this.func_70624_b((EntityLivingBase)entity);
            this.func_70625_a(entity, 180.0f, 180.0f);
            this.kickoff = true;
        }
        if (this.isFriendly()) {
            this.func_70624_b(null);
        }
        return flag;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.isFriendly() && !this.hasPrey()) {
            return;
        }
        if (this.func_70638_az() == null && !this.hasPrey() && this.func_110143_aJ() >= 0.0f) {
            if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
                this.slimeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
                this.field_70703_bu = true;
                this.field_70181_x = 0.35f;
                this.func_184185_a(SoundEvents.field_187882_fq, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
                this.field_191988_bg = 16.0f;
            } else {
                this.field_70703_bu = false;
                if (this.field_70122_E) {
                    this.field_191988_bg = 0.0f;
                    this.field_70702_br = 0.0f;
                }
            }
        }
        if (!this.field_70122_E && this.field_70703_bu) {
            this.field_70703_bu = false;
        }
        if (this.func_70638_az() != null && !this.hasPrey() && this.func_110143_aJ() >= 0.0f) {
            if (!this.func_70685_l((Entity)this.func_70638_az()) || this.func_70638_az() instanceof EntityPlayer && ((EntityPlayer)this.func_70638_az()).field_71075_bZ.field_75098_d) {
                this.func_70624_b(null);
                return;
            }
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 10.0f);
            if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
                this.slimeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
                this.field_70703_bu = true;
                this.field_70181_x = 0.35f;
                this.func_184185_a(SoundEvents.field_187882_fq, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                this.field_70702_br = 1.0f;
                this.field_191988_bg = 16.0f;
            } else {
                this.field_70703_bu = false;
                if (this.field_70122_E) {
                    this.field_191988_bg = 0.0f;
                    this.field_70702_br = 0.0f;
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (!this.field_70122_E && this.field_70181_x < (double)0.05f && this.flutter > 0) {
            this.field_70181_x += (double)0.07f;
            --this.flutter;
        }
        if (this.ticker < 4) {
            ++this.ticker;
        } else {
            if (this.field_70122_E && !this.hasPrey() && this.hops != 0 && this.hops != 3) {
                this.hops = 0;
            }
            if (this.func_70638_az() == null && !this.hasPrey() && !this.isFriendly()) {
                EntityLivingBase entity = this.getPrey();
                if (entity != null) {
                    this.func_70624_b(entity);
                }
            } else if (this.func_70638_az() != null && !this.hasPrey()) {
                if (this.func_70032_d((Entity)this.func_70638_az()) <= 9.0f) {
                    if (this.field_70122_E && this.func_70685_l((Entity)this.func_70638_az())) {
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187886_fs, SoundCategory.HOSTILE, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f, false);
                        this.flutter = 10;
                        this.field_70703_bu = true;
                        this.field_191988_bg = 1.0f;
                        this.field_70177_z += 5.0f * (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat());
                    }
                } else {
                    this.func_70624_b(null);
                    this.field_70703_bu = false;
                    this.field_191988_bg = 0.0f;
                }
            } else if (this.hasPrey() && this.field_70122_E) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187886_fs, SoundCategory.HOSTILE, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f, false);
                if (!this.isFriendly()) {
                    ++this.hops;
                }
                this.flutter = 5;
                this.field_70122_E = false;
                this.field_70177_z += 20.0f * (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat());
                if (this.hops == 0) {
                    this.field_70181_x = 0.35f;
                    this.field_191988_bg = 0.8f;
                } else if (this.hops == 1) {
                    this.field_70181_x = 0.45f;
                    this.field_191988_bg = 0.9f;
                } else if (this.hops == 2) {
                    this.field_70181_x = 1.25;
                    this.field_191988_bg = 1.25f;
                }
            }
            this.ticker = 0;
        }
        if (this.field_70122_E && this.hops >= 3) {
            this.dissolve();
        }
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.hasPrey()) {
            super.func_191986_a(strafe, vertical, forward);
            return;
        }
        EntityLivingBase prey = this.getPrey();
        if (prey instanceof EntityPlayer) {
            EntityPlayer rider = (EntityPlayer)prey;
            IPlayerAether aetherRider = AetherAPI.getInstance().get(rider);
            if (aetherRider == null) {
                return;
            }
            if (aetherRider.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.swet_cape))) {
                this.setFriendly(true);
            }
            if (this.isFriendly()) {
                this.field_70126_B = this.field_70177_z = rider.field_70177_z;
                this.field_70125_A = rider.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
                    strafe = rider.field_70702_br * 2.0f;
                    vertical = rider.field_70701_bs * 2.0f;
                    forward = rider.field_191988_bg * 2.0f;
                    if (strafe != 0.0f || forward != 0.0f) {
                        this.func_70664_aZ();
                        this.field_70122_E = false;
                        this.field_70181_x = 0.7f;
                        this.slimeJumpDelay = this.field_70146_Z.nextInt(4);
                    }
                    if (aetherRider.isJumping()) {
                        this.func_70664_aZ();
                        this.field_70122_E = false;
                        this.field_70181_x = 1.0;
                        this.slimeJumpDelay = this.field_70146_Z.nextInt(15);
                    }
                    int rotate = MathHelper.func_76128_c((double)((double)(rider.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                    double x = Math.cos(this.func_70040_Z().field_72450_a);
                    double z = Math.cos(this.func_70040_Z().field_72449_c);
                    if (forward > 0.0f) {
                        this.field_70159_w = this.func_70040_Z().field_72450_a / 2.0;
                        this.field_70179_y = this.func_70040_Z().field_72449_c / 2.0;
                    }
                    if (forward < 0.0f) {
                        this.field_70159_w = -this.func_70040_Z().field_72450_a / 2.0;
                        this.field_70179_y = -this.func_70040_Z().field_72449_c / 2.0;
                    }
                    if (strafe > 0.0f) {
                        if (rotate <= 1) {
                            this.field_70159_w = x / 2.0;
                            this.field_70179_y = z / 2.0;
                        } else {
                            this.field_70159_w = -x / 2.0;
                            this.field_70179_y = -z / 2.0;
                        }
                    }
                    if (strafe < 0.0f) {
                        if (rotate <= 1) {
                            this.field_70159_w = -x / 2.0;
                            this.field_70179_y = -z / 2.0;
                        } else {
                            this.field_70159_w = x / 2.0;
                            this.field_70179_y = z / 2.0;
                        }
                    }
                } else if (this.field_70122_E) {
                    return;
                }
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_191986_a(strafe, vertical, forward);
                }
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_191986_a(this.field_191988_bg, this.field_70701_bs, this.field_70702_br);
            }
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(this.field_191988_bg, this.field_70701_bs, this.field_70702_br);
        }
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
        this.func_184185_a(SoundEvents.field_187882_fq, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Hops", this.hops);
        compound.func_74768_a("Flutter", this.flutter);
        compound.func_74757_a("Friendly", this.isFriendly());
        compound.func_74768_a("SwetType", this.getType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.hops = compound.func_74762_e("Hops");
        this.flutter = compound.func_74762_e("Flutter");
        this.setFriendly(compound.func_74767_n("Friendly"));
        this.setType(compound.func_74762_e("SwetType"));
    }

    public boolean isFriendly() {
        return this.isFriendly;
    }

    private void setFriendly(boolean friendly) {
        this.isFriendly = friendly;
    }

    public int getType() {
        return this.swetType;
    }

    private void setType(int type) {
        this.swetType = type;
    }

    public int getAttackCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_COOLDOWN);
    }

    private void setAttackCooldown(int timeLeft) {
        this.field_70180_af.func_187227_b(ATTACK_COOLDOWN, (Object)timeLeft);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187886_fs;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187874_fm;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFriendly()) {
                return true;
            }
            if (!this.hasPrey() && !this.isFriendly()) {
                this.capturePrey((EntityLivingBase)player);
            } else if (this.isPrey((Entity)player)) {
                player.func_184210_p();
            }
        }
        return true;
    }

    protected EntityLivingBase getPrey() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(6.0, 6.0, 6.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityLivingBase) || entity instanceof EntitySwet || !(this.isFriendly() ? !(entity instanceof EntityPlayer) : !(entity instanceof EntityMob))) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    public boolean isPrey(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        if (!this.hasPrey()) {
            return false;
        }
        return this.func_184188_bt().get(0) == entity;
    }

    public boolean hasPrey() {
        return !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) != null;
    }

    protected void func_70628_a(boolean var1, int var2) {
        ItemStack droppedItem = new ItemStack(this.getType() == 1 ? BlocksAether.aercloud : Blocks.field_150426_aN, 1, this.getType() == 1 ? 1 : 0);
        this.func_70099_a(droppedItem, 0.0f);
        if (this.getType() == 1) {
            // empty if block
        }
        this.func_145779_a(ItemsAether.swetty_ball, 1);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }
}

