/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.bosses.sun_spirit;

import com.legacy.aether.Aether;
import com.legacy.aether.advancements.AetherAdvancements;
import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.api.player.util.IAetherBoss;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.dungeon.BlockDungeonBase;
import com.legacy.aether.blocks.util.EnumStoneType;
import com.legacy.aether.entities.bosses.EntityFireMinion;
import com.legacy.aether.entities.projectile.crystals.EntityFireBall;
import com.legacy.aether.entities.projectile.crystals.EntityIceyBall;
import com.legacy.aether.entities.util.AetherNameGen;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.registry.sounds.SoundsAether;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class EntitySunSpirit
extends EntityFlying
implements IMob,
IAetherBoss,
IEntityMultiPart {
    public static final DataParameter<String> SUN_SPIRIT_NAME = EntityDataManager.func_187226_a(EntitySunSpirit.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> CHAT_LINE = EntityDataManager.func_187226_a(EntitySunSpirit.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> FROZEN = EntityDataManager.func_187226_a(EntitySunSpirit.class, (DataSerializer)DataSerializers.field_187198_h);
    public int originPointX;
    public int originPointY;
    public int originPointZ;
    public int motionTimer;
    public int flameCount;
    public int ballCount;
    public int chatLog;
    public int chatCount;
    public int direction;
    public double rotary;
    public double velocity;
    public MultiPartEntityPart SpiritPartHead = new MultiPartEntityPart((IEntityMultiPart)this, "head", 6.0f, 6.0f);

    public EntitySunSpirit(World world) {
        super(world);
    }

    public EntitySunSpirit(World world, int posX, int posY, int posZ, int var6) {
        super(world);
        this.func_70105_a(2.25f, 2.6f);
        this.func_70107_b((double)posX + 0.5, posY, (double)posZ + 0.5);
        this.setOriginPosition(posX, posY, posZ);
        this.setBossName(AetherNameGen.gen());
        this.field_70145_X = true;
        this.rotary = (double)this.field_70146_Z.nextFloat() * 360.0;
        this.direction = var6;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 200.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_70606_j(50.0f);
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.func_70638_az() != null) {
            super.func_70091_d(type, x, 0.0, z);
        } else {
            super.func_70091_d(type, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected SoundEvent getHurtSound() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUN_SPIRIT_NAME, (Object)AetherNameGen.gen());
        this.field_70180_af.func_187214_a(CHAT_LINE, (Object)0);
        this.field_70180_af.func_187214_a(FROZEN, (Object)false);
    }

    public boolean isDead() {
        return this.func_110143_aJ() <= 0.0f || this.field_70128_L;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("originPointX", this.originPointX);
        tag.func_74768_a("originPointY", this.originPointY);
        tag.func_74768_a("originPointZ", this.originPointZ);
        tag.func_74768_a("dungeonDirection", this.direction);
        tag.func_74768_a("chatLog", this.getChatLine());
        tag.func_74778_a("bossName", this.getBossName());
        tag.func_74757_a("isFreezing", this.isFreezing());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.originPointX = tag.func_74762_e("originPointX");
        this.originPointY = tag.func_74762_e("originPointY");
        this.originPointZ = tag.func_74762_e("originPointZ");
        this.direction = tag.func_74762_e("dungeonDirection");
        this.setChatLine(tag.func_74762_e("chatLog"));
        this.setBossName(tag.func_74779_i("bossName"));
        this.setFreezing(tag.func_74767_n("isFreezing"));
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.velocity = 0.5 - (double)this.func_110143_aJ() / 70.0 * 0.2;
        this.field_70131_O = 2.0f;
        this.field_70130_N = 2.0f;
        if (this.func_70638_az() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_70638_az();
            IPlayerAether playerAether = AetherAPI.getInstance().get(player);
            if (player.field_70128_L) {
                this.func_70107_b((double)this.originPointX + 0.5, this.originPointY, (double)this.originPointZ + 0.5);
                this.chatLog = 10;
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                this.chatLine(player, new TextComponentTranslation("gui.spirit.playerdied", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.chatCount = 100;
                this.func_70107_b((double)this.originPointX + 0.5, this.originPointY, (double)this.originPointZ + 0.5);
                this.setDoor(Blocks.field_150350_a.func_176223_P());
                this.setFreezing(false);
                this.func_70624_b(null);
                this.func_70606_j(this.func_110138_aP());
            } else {
                playerAether.setFocusedBoss(this);
            }
            if (this.isDead()) {
                this.chatLine(player, new TextComponentTranslation("gui.spirit.dead", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
                this.chatCount = 100;
                if (player instanceof EntityPlayerMP) {
                    AetherAdvancements.DEFEAT_SUN_SPIRIT_TRIGGER.trigger((EntityPlayerMP)player);
                }
                this.setDoor(Blocks.field_150350_a.func_176223_P());
                this.unlockTreasure();
            }
        }
        this.setFreezing(this.field_70737_aN > 0);
        if (this.func_110143_aJ() > 0.0f) {
            double xCoord = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.field_70146_Z.nextFloat());
            double yCoord = this.func_174813_aQ().field_72338_b + (double)this.field_70146_Z.nextFloat() - 0.5;
            double zCoord = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.field_70146_Z.nextFloat());
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, xCoord, yCoord, zCoord, 0.0, (double)-0.075f, 0.0, new int[0]);
            this.burnEntities();
            this.evapWater();
        }
        if (this.chatCount > 0) {
            --this.chatCount;
        }
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.field_70181_x = 0.0;
            this.field_70761_aq = this.field_70177_z;
            this.func_70107_b(this.field_70165_t, this.originPointY, this.field_70161_v);
            boolean changedCourse = false;
            if (this.field_70159_w >= 0.0 && this.field_70165_t >= (double)this.originPointX + 11.0) {
                this.rotary = 360.0 - this.rotary;
                changedCourse = true;
            } else if (this.field_70159_w <= 0.0 && this.field_70165_t <= (double)this.originPointX - 11.0) {
                this.rotary = 360.0 - this.rotary;
                changedCourse = true;
            }
            if (this.field_70179_y >= 0.0 && this.field_70161_v >= (double)this.originPointZ + 11.0) {
                this.rotary = 180.0 - this.rotary;
                changedCourse = true;
            } else if (this.field_70179_y <= 0.0 && this.field_70161_v <= (double)this.originPointZ - 11.0) {
                this.rotary = 180.0 - this.rotary;
                changedCourse = true;
            }
            if (this.rotary > 360.0) {
                this.rotary -= 360.0;
            } else if (this.rotary < 0.0) {
                this.rotary += 360.0;
            }
            this.func_70625_a((Entity)this.func_70638_az(), 20.0f, 20.0f);
            double angle = this.rotary / 57.29577951308232;
            this.field_70159_w = Math.sin(angle) * this.velocity;
            this.field_70179_y = Math.cos(angle) * this.velocity;
            ++this.motionTimer;
            if (this.motionTimer >= 20 || changedCourse) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.rotary += (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 60.0;
                }
                this.motionTimer = 0;
            }
            ++this.flameCount;
            if (this.flameCount == 40) {
                this.summonFire();
            } else if ((float)this.flameCount >= 55.0f + this.func_110143_aJ() / 2.0f) {
                this.makeFireBall(1);
                this.flameCount = 0;
            }
        }
    }

    public void burnEntities() {
        List entityList = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(0.0, 4.0, 0.0));
        for (int ammount = 0; ammount < entityList.size(); ++ammount) {
            Entity entity = (Entity)entityList.get(ammount);
            if (!(entity instanceof EntityLivingBase) || entity.func_70045_F()) continue;
            entity.func_70097_a((DamageSource)new EntityDamageSource("incineration", (Entity)this), 10.0f);
            entity.func_70015_d(15);
        }
    }

    public void evapWater() {
        int var1 = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72340_a + (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) / 2.0));
        int var2 = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72339_c + (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) / 2.0));
        int radius = 10;
        for (int var4 = var1 - radius; var4 <= var1 + radius; ++var4) {
            for (int var5 = var2 - radius; var5 <= var2 + radius; ++var5) {
                for (int var6 = 0; var6 < 8; ++var6) {
                    int var7 = this.originPointY - 2 + var6;
                    if (this.field_70170_p.func_180495_p(new BlockPos(var4, var7, var5)).func_185904_a() != Material.field_151586_h) continue;
                    this.field_70170_p.func_175656_a(new BlockPos(var4, var7, var5), Blocks.field_150350_a.func_176223_P());
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.HOSTILE, 2.0f, this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f, false);
                    for (int var8 = 0; var8 < 8; ++var8) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)var4 + Math.random(), (double)var7 + 0.75, (double)var5 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public void makeFireBall(int var1) {
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundsAether.sun_spirit_shoot, SoundCategory.HOSTILE, this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat() * 0.2f + 1.2f, 1.0f);
        boolean shootIceyBall = false;
        ++this.ballCount;
        if (this.ballCount >= 3 + this.field_70146_Z.nextInt(3)) {
            shootIceyBall = true;
            this.ballCount = 0;
        }
        for (int var3 = 0; var3 < var1; ++var3) {
            if (!shootIceyBall) {
                EntityFireBall fireball = new EntityFireBall(this.field_70170_p, this.field_70165_t - this.field_70159_w / 2.0, this.field_70163_u, this.field_70161_v - this.field_70179_y / 2.0);
                if (!this.field_70170_p.field_72995_K) {
                    fireball.shootingEntity = this;
                    this.field_70170_p.func_72838_d((Entity)fireball);
                }
            }
            if (!shootIceyBall) continue;
            EntityIceyBall iceBall = new EntityIceyBall(this.field_70170_p, this.field_70165_t - this.field_70159_w / 2.0, this.field_70163_u, this.field_70161_v - this.field_70179_y / 2.0, false);
            if (this.field_70170_p.field_72995_K) continue;
            iceBall.shootingEntity = this;
            this.field_70170_p.func_72838_d((Entity)iceBall);
        }
    }

    public void summonFire() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_175623_d(new BlockPos(x, y = this.originPointY - 2, z = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            this.field_70170_p.func_175656_a(new BlockPos(x, y, z), Blocks.field_150480_ab.func_176223_P());
        }
    }

    private void chatLine(EntityPlayer player, ITextComponent s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.chatCount <= 0 && side.isClient()) {
            Aether.proxy.sendMessage(player, s);
        }
    }

    public boolean chatWithMe(EntityPlayer entityPlayer) {
        if (this.chatCount <= 0) {
            if (this.getChatLine() == 0) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line0", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(1);
            } else if (this.getChatLine() == 1) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(2);
            } else if (this.getChatLine() == 2) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line2", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(3);
            } else if (this.getChatLine() == 3) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line3", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(4);
            } else if (this.getChatLine() == 4) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line4", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(5);
            } else if (this.getChatLine() == 5) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line5.1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line5.2", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(6);
            } else if (this.getChatLine() == 6) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line6.1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line6.2", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(7);
            } else if (this.getChatLine() == 7) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line7.1", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line7.2", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(8);
            } else if (this.getChatLine() == 8) {
                this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line8", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                this.setChatLine(9);
            } else {
                if (this.getChatLine() == 9) {
                    this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line9", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
                    this.setChatLine(10);
                    return true;
                }
                if (this.getChatLine() == 10 && this.func_70638_az() == null) {
                    this.chatLine(entityPlayer, new TextComponentTranslation("gui.spirit.line10", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    this.setChatLine(9);
                }
            }
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.chatWithMe(player)) {
            this.func_70624_b((EntityLivingBase)player);
            this.setDoor(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Hellfire)));
            return true;
        }
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70653_a(Entity entity, float strength, double xRatio, double zRatio) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityIceyBall) {
            this.velocity = 0.5 - (double)this.func_110143_aJ() / 70.0 * 0.2;
            boolean flag = super.func_70097_a(source, amount);
            if (flag) {
                EntityFireMinion minion = new EntityFireMinion(this.field_70170_p);
                minion.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)minion);
                }
            }
            return flag;
        }
        return false;
    }

    protected void func_70628_a(boolean var1, int var2) {
        this.func_70099_a(new ItemStack(ItemsAether.dungeon_key, 1, 2), 0.5f);
        this.func_70099_a(new ItemStack(BlocksAether.sun_altar), 0.5f);
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190916_E() != 0 && stack.func_77973_b() != null) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entityitem.func_184224_h(true);
            entityitem.func_174869_p();
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    private void setDoor(IBlockState block) {
        if (this.direction / 2 == 0) {
            for (int y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (int z = this.originPointZ - 1; z < this.originPointZ + 2; ++z) {
                    BlockPos pos = new BlockPos(this.originPointX + (this.direction == 0 ? -13 : 13), y, z);
                    this.field_70170_p.func_180501_a(pos, block, 2);
                }
            }
        } else {
            for (int y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (int x = this.originPointX - 1; x < this.originPointX + 2; ++x) {
                    BlockPos pos = new BlockPos(x, y, this.originPointZ + (this.direction != 3 ? 13 : -13));
                    this.field_70170_p.func_180501_a(pos, block, 2);
                }
            }
        }
    }

    private void unlockTreasure() {
        int x;
        int z;
        int y;
        if (this.direction / 2 == 0) {
            for (y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (z = this.originPointZ - 1; z < this.originPointZ + 2; ++z) {
                    this.field_70170_p.func_175656_a(new BlockPos(this.originPointX + (this.direction == 0 ? 13 : -13), y, z), Blocks.field_150350_a.func_176223_P());
                }
            }
        } else {
            for (y = this.originPointY - 1; y < this.originPointY + 2; ++y) {
                for (x = this.originPointX - 1; x < this.originPointX + 2; ++x) {
                    this.field_70170_p.func_175656_a(new BlockPos(x, y, this.originPointZ + (this.direction != 3 ? -13 : 13)), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        for (x = this.originPointX - 20; x < this.originPointX + 20; ++x) {
            for (y = this.originPointY - 3; y < this.originPointY + 6; ++y) {
                for (z = this.originPointZ - 20; z < this.originPointZ + 20; ++z) {
                    BlockPos newPos = new BlockPos(x, y, z);
                    IBlockState unlock_block = this.field_70170_p.func_180495_p(newPos);
                    if (unlock_block == BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Hellfire))) {
                        this.field_70170_p.func_180501_a(newPos, BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.getType(unlock_block.func_177230_c().func_176201_c(unlock_block)))), 2);
                        continue;
                    }
                    if (unlock_block != BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_hellfire))) continue;
                    this.field_70170_p.func_180501_a(newPos, BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.getType(unlock_block.func_177230_c().func_176201_c(unlock_block)))), 2);
                }
            }
        }
    }

    public void setOriginPosition(int x, int y, int z) {
        this.originPointX = x;
        this.originPointY = y;
        this.originPointZ = z;
    }

    public String getBossName() {
        return (String)this.field_70180_af.func_187225_a(SUN_SPIRIT_NAME);
    }

    public void setBossName(String name) {
        this.field_70180_af.func_187227_b(SUN_SPIRIT_NAME, (Object)name);
    }

    @Override
    public String getBossTitle() {
        return this.getBossName() + ", " + new TextComponentTranslation("title.aether_legacy.sun_spirit.name", new Object[0]).func_150254_d();
    }

    public int getChatLine() {
        return (Integer)this.field_70180_af.func_187225_a(CHAT_LINE);
    }

    public void setChatLine(int lineNumber) {
        this.chatCount = 100;
        this.field_70180_af.func_187227_b(CHAT_LINE, (Object)lineNumber);
    }

    public boolean isFreezing() {
        return (Boolean)this.field_70180_af.func_187225_a(FROZEN);
    }

    public void setFreezing(boolean isFreezing) {
        this.field_70180_af.func_187227_b(FROZEN, (Object)isFreezing);
    }

    public float func_70047_e() {
        return 2.1f;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70965_a(MultiPartEntityPart spiritPart, DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }
}

