/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.guntram.mcmod.durabilityviewer.DurabilityViewer;
import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemCountIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import de.guntram.mcmod.durabilityviewer.sound.ItemBreakingWarner;
import java.util.Collection;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

public class GuiItemDurability
extends IngameGui {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private static boolean visible;
    private final FontRenderer fontRenderer;
    private final ItemRenderer itemRenderer;
    private static final int iconWidth = 16;
    private static final int iconHeight = 16;
    private static final int spacing = 2;
    private ItemBreakingWarner mainHandWarner;
    private ItemBreakingWarner offHandWarner;
    private ItemBreakingWarner helmetWarner;
    private ItemBreakingWarner chestWarner;
    private ItemBreakingWarner pantsWarner;
    private ItemBreakingWarner bootsWarner;

    public static void toggleVisibility() {
        visible = !visible;
    }

    public GuiItemDurability() {
        super(Minecraft.func_71410_x());
        this.fontRenderer = this.minecraft.field_71466_p;
        this.itemRenderer = this.minecraft.func_175599_af();
        visible = true;
        this.mainHandWarner = new ItemBreakingWarner();
        this.offHandWarner = new ItemBreakingWarner();
        this.helmetWarner = new ItemBreakingWarner();
        this.chestWarner = new ItemBreakingWarner();
        this.pantsWarner = new ItemBreakingWarner();
        this.bootsWarner = new ItemBreakingWarner();
    }

    private int getInventoryArrowCount() {
        int arrows = 0;
        for (ItemStack stack : this.minecraft.field_71439_g.field_71071_by.field_70462_a) {
            if (!this.isArrow(stack)) continue;
            arrows += stack.func_190916_E();
        }
        return arrows;
    }

    private ItemStack getFirstArrowStack() {
        if (this.isArrow(this.minecraft.field_71439_g.func_184586_b(Hand.OFF_HAND))) {
            return this.minecraft.field_71439_g.func_184586_b(Hand.OFF_HAND);
        }
        if (this.isArrow(this.minecraft.field_71439_g.func_184586_b(Hand.MAIN_HAND))) {
            return this.minecraft.field_71439_g.func_184586_b(Hand.MAIN_HAND);
        }
        int size = this.minecraft.field_71439_g.field_71071_by.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemstack = this.minecraft.field_71439_g.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrow(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ArrowItem;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRender(RenderGameOverlayEvent.Post event) {
        int ypos;
        int xposTools;
        int xposArmor;
        String newTitle = DurabilityViewer.getAndResetChangedWindowTitle();
        if (newTitle != null) {
            GLFW.glfwSetWindowTitle((long)this.minecraft.func_228018_at_().func_198092_i(), (CharSequence)newTitle);
        }
        if (!visible || event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            return;
        }
        ClientPlayerEntity effectivePlayer = this.minecraft.field_71439_g;
        boolean needToWarn = false;
        ItemDamageIndicator mainHand = new ItemDamageIndicator(effectivePlayer.func_184582_a(EquipmentSlotType.MAINHAND));
        ItemDamageIndicator offHand = new ItemDamageIndicator(effectivePlayer.func_184582_a(EquipmentSlotType.OFFHAND));
        ItemDamageIndicator boots = new ItemDamageIndicator(effectivePlayer.func_184582_a(EquipmentSlotType.FEET));
        ItemDamageIndicator leggings = new ItemDamageIndicator(effectivePlayer.func_184582_a(EquipmentSlotType.LEGS));
        ItemDamageIndicator chestplate = new ItemDamageIndicator(effectivePlayer.func_184582_a(EquipmentSlotType.CHEST));
        ItemDamageIndicator helmet = new ItemDamageIndicator(effectivePlayer.func_184582_a(EquipmentSlotType.HEAD));
        ItemCountIndicator arrows = null;
        InventorySlotsIndicator invSlots = ConfigurationHandler.getShowChestIcon() ? new InventorySlotsIndicator(this.minecraft.field_71439_g.field_71071_by) : null;
        needToWarn |= this.mainHandWarner.checkBreaks(effectivePlayer.func_184582_a(EquipmentSlotType.MAINHAND));
        needToWarn |= this.offHandWarner.checkBreaks(effectivePlayer.func_184582_a(EquipmentSlotType.OFFHAND));
        needToWarn |= this.bootsWarner.checkBreaks(effectivePlayer.func_184582_a(EquipmentSlotType.FEET));
        needToWarn |= this.pantsWarner.checkBreaks(effectivePlayer.func_184582_a(EquipmentSlotType.LEGS));
        needToWarn |= this.chestWarner.checkBreaks(effectivePlayer.func_184582_a(EquipmentSlotType.CHEST));
        if (needToWarn |= this.helmetWarner.checkBreaks(effectivePlayer.func_184582_a(EquipmentSlotType.HEAD))) {
            ItemBreakingWarner.playWarningSound();
        }
        if (mainHand.getItemStack().func_77973_b() instanceof BowItem || offHand.getItemStack().func_77973_b() instanceof BowItem) {
            arrows = new ItemCountIndicator(this.getFirstArrowStack(), this.getInventoryArrowCount());
        }
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        MatrixStack stack = event.getMatrixStack();
        RenderSize armorSize = this.renderItems(stack, 0, 0, false, RenderPos.left, 0, boots, leggings, chestplate, helmet);
        RenderSize toolsSize = this.renderItems(stack, 0, 0, false, RenderPos.right, 0, invSlots, mainHand, offHand, arrows);
        int totalHeight = toolsSize.height > armorSize.height ? toolsSize.height : armorSize.height;
        int totalWidth = toolsSize.width > armorSize.width ? toolsSize.width : armorSize.width;
        switch (ConfigurationHandler.getCorner()) {
            case TOP_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = 5;
                break;
            }
            case TOP_RIGHT: {
                xposArmor = mainWindow.func_198107_o() - 5 - armorSize.width;
                xposTools = mainWindow.func_198107_o() - 5 - armorSize.width - toolsSize.width;
                ypos = 60;
                break;
            }
            case BOTTOM_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = mainWindow.func_198087_p() - 5 - totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                xposArmor = mainWindow.func_198107_o() - 5 - armorSize.width;
                xposTools = mainWindow.func_198107_o() - 5 - armorSize.width - toolsSize.width;
                ypos = mainWindow.func_198087_p() - 5 - totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ConfigurationHandler.getArmorAroundHotbar()) {
            int leftOffset = -120;
            int rightOffset = 100;
            if (!effectivePlayer.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b()) {
                if (this.minecraft.field_71474_y.field_186715_A == HandSide.RIGHT) {
                    leftOffset -= 20;
                } else {
                    rightOffset += 20;
                }
            }
            int helmetTextWidth = this.fontRenderer.func_78256_a(helmet.getDisplayValue());
            int chestTextWidth = this.fontRenderer.func_78256_a(chestplate.getDisplayValue());
            this.renderItems(stack, mainWindow.func_198107_o() / 2 + leftOffset - helmetTextWidth, mainWindow.func_198087_p() - 32 - 2, true, RenderPos.left, helmetTextWidth + 16 + 2, helmet);
            this.renderItems(stack, mainWindow.func_198107_o() / 2 + leftOffset - chestTextWidth, mainWindow.func_198087_p() - 16 - 2, true, RenderPos.left, chestTextWidth + 16 + 2, chestplate);
            this.renderItems(stack, mainWindow.func_198107_o() / 2 + rightOffset, mainWindow.func_198087_p() - 32 - 2, true, RenderPos.right, armorSize.width, leggings);
            this.renderItems(stack, mainWindow.func_198107_o() / 2 + rightOffset, mainWindow.func_198087_p() - 16 - 2, true, RenderPos.right, armorSize.width, boots);
            xposTools = ConfigurationHandler.getCorner().isRight() ? (xposTools += armorSize.width) : (xposTools -= armorSize.width);
        } else {
            this.renderItems(stack, xposArmor, ypos, true, ConfigurationHandler.getCorner().isLeft() ? RenderPos.left : RenderPos.right, armorSize.width, helmet, chestplate, leggings, boots);
        }
        this.renderItems(stack, xposTools, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, toolsSize.width, invSlots, mainHand, offHand, arrows);
        RenderHelper.func_74518_a();
        if (ConfigurationHandler.showEffectDuration()) {
            Collection collection = this.minecraft.field_71439_g.func_70651_bq();
            int posGood = 0;
            int posBad = 0;
            for (EffectInstance potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                if (!potioneffect.func_188418_e()) continue;
                Effect potion = potioneffect.func_188419_a();
                int xpos = mainWindow.func_198107_o();
                if (potion.func_188408_i()) {
                    xpos -= (posGood += 25);
                    ypos = 15;
                } else {
                    xpos -= (posBad += 25);
                    ypos = 41;
                }
                int duration = potioneffect.func_76459_b();
                String show = duration > 1200 ? duration / 1200 + "m" : duration / 20 + "s";
                this.fontRenderer.func_238421_b_(event.getMatrixStack(), show, (float)(xpos + 2), (float)ypos, ItemIndicator.color_yellow);
            }
        }
    }

    private RenderSize renderItems(MatrixStack stack, int xpos, int ypos, boolean reallyDraw, RenderPos numberPos, int maxWidth, ItemIndicator ... items) {
        RenderSize result = new RenderSize(0, 0);
        for (ItemIndicator item : items) {
            if (item == null || item.isEmpty() || !item.isItemStackDamageable()) continue;
            String displayString = item.getDisplayValue();
            int width = this.fontRenderer.func_78256_a(displayString);
            if (width > result.width) {
                result.width = width;
            }
            if (reallyDraw) {
                int color = item.getDisplayColor();
                this.itemRenderer.func_180450_b(item.getItemStack(), numberPos == RenderPos.left ? xpos + maxWidth - 16 - 2 : xpos, ypos + result.height);
                float f = numberPos != RenderPos.right ? (float)xpos : (float)(xpos + 16 + 2);
                int n = ypos + result.height;
                this.fontRenderer.getClass();
                this.fontRenderer.func_238421_b_(stack, displayString, f, (float)(n + 9 / 2 + (numberPos == RenderPos.over ? 10 : 0)), color);
            }
            result.height += 16;
        }
        if (result.width != 0) {
            result.width += 20;
        }
        return result;
    }

    private static enum RenderPos {
        left,
        over,
        right;

    }

    private class RenderSize {
        int width;
        int height;

        RenderSize(int w, int h) {
            this.width = w;
            this.height = h;
        }
    }
}

