/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.lib.ReflectedField;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public final class WorldUtils {
    private static final ReflectedField.ObjectField<WorldClient, Set<Entity>> entityList = new ReflectedField.ObjectField(WorldClient.class, "entityList", "field_73032_d");

    private WorldUtils() {
    }

    @Nonnull
    public static IBlockAccessEx getDefaultBlockStateProvider() {
        return ClientChunkCache.instance();
    }

    @Nullable
    public static Entity locateEntity(@Nonnull World world, int entityId) {
        Entity entity = null;
        if (world != null) {
            try {
                entity = world.func_73045_a(entityId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return entity;
    }

    public static boolean isSolidBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getBlockState(world, pos).func_185904_a().func_76220_a();
    }

    public static boolean isAirBlock(@Nonnull IBlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a;
    }

    public static boolean isLeaves(@Nonnull IBlockState state) {
        return state.func_185904_a() == Material.field_151584_j;
    }

    public static boolean isAirBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.isAirBlock(WorldUtils.getBlockState(world, pos));
    }

    @Nonnull
    public static IBlockState getBlockState(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getDefaultBlockStateProvider().func_180495_p(pos);
    }

    @Nonnull
    public static IBlockState getBlockState(@Nonnull World world, int x, int y, int z) {
        return WorldUtils.getDefaultBlockStateProvider().getBlockState(x, y, z);
    }

    public static boolean isFullWaterBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.isFullWaterBlock(WorldUtils.getDefaultBlockStateProvider().func_180495_p(pos));
    }

    public static boolean isFullWaterBlock(@Nonnull IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h && state.func_177230_c().func_176223_P() == state;
    }

    public static boolean hasVoidPartiles(@Nonnull World world) {
        return world.func_175624_G() != WorldType.field_77138_c && world.field_73011_w.func_191066_m();
    }

    @Nonnull
    public static ObjectArray<Entity> gatherEntitiesInView(@Nonnull Entity viewer, int rangeSq, float partialTicks) {
        ObjectArray<Entity> result = new ObjectArray<Entity>();
        if (Minecraft.func_71382_s()) {
            Frustum frustum = new Frustum();
            double viewX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
            double viewY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
            double viewZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
            frustum.func_78547_a(viewX, viewY, viewZ);
            WorldClient client = (WorldClient)viewer.func_130014_f_();
            Set<Entity> entities = entityList.get(client);
            for (Entity entity : entities) {
                if (entity == null || !entity.func_70089_S() || !(viewer.func_70068_e(entity) <= (double)rangeSq) || !entity.field_70158_ak && !frustum.func_78546_a(entity.func_174813_aQ())) continue;
                result.add(entity);
            }
        }
        return result;
    }
}

