/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderModCapes {
    public ResourceLocation redTex = new ResourceLocation("iceandfire", "textures/models/misc/cape_fire.png");
    public ResourceLocation redElytraTex = new ResourceLocation("iceandfire", "textures/models/misc/elytra_fire.png");
    public ResourceLocation blueTex = new ResourceLocation("iceandfire", "textures/models/misc/cape_ice.png");
    public ResourceLocation blueElytraTex = new ResourceLocation("iceandfire", "textures/models/misc/elytra_ice.png");
    public ResourceLocation betaTex = new ResourceLocation("iceandfire", "textures/models/misc/cape_beta.png");
    public ResourceLocation betaElytraTex = new ResourceLocation("iceandfire", "textures/models/misc/elytra_beta.png");
    public UUID[] redcapes = new UUID[]{UUID.fromString("59efccaf-902d-45da-928a-5a549b9fd5e0"), UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c")};
    public UUID[] bluecapes = new UUID[]{UUID.fromString("0ed918c8-d612-4360-b711-cd415671356f"), UUID.fromString("5d43896a-06a0-49fb-95c5-38485c63667f")};
    public UUID[] betatesters = new UUID[0];

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer() instanceof AbstractClientPlayer) {
            NetworkPlayerInfo info = null;
            try {
                info = (NetworkPlayerInfo)ReflectionHelper.findField(AbstractClientPlayer.class, (String[])new String[]{"playerInfo", "field_175157_a"}).get(event.getEntityPlayer());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (info != null) {
                Map textureMap = null;
                try {
                    textureMap = (Map)ReflectionHelper.findField(NetworkPlayerInfo.class, (String[])new String[]{"playerTextures", "field_187107_a"}).get(info);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (textureMap != null) {
                    if (this.hasBetaCape(event.getEntityPlayer().func_110124_au())) {
                        textureMap.put(MinecraftProfileTexture.Type.CAPE, this.betaTex);
                        textureMap.put(MinecraftProfileTexture.Type.ELYTRA, this.betaElytraTex);
                    }
                    if (this.hasRedCape(event.getEntityPlayer().func_110124_au())) {
                        textureMap.put(MinecraftProfileTexture.Type.CAPE, this.redTex);
                        textureMap.put(MinecraftProfileTexture.Type.ELYTRA, this.redElytraTex);
                    }
                    if (this.hasBlueCape(event.getEntityPlayer().func_110124_au())) {
                        textureMap.put(MinecraftProfileTexture.Type.CAPE, this.blueTex);
                        textureMap.put(MinecraftProfileTexture.Type.ELYTRA, this.blueElytraTex);
                    }
                }
            }
        }
    }

    private boolean hasRedCape(UUID uniqueID) {
        for (UUID uuid1 : this.redcapes) {
            if (!uniqueID.equals(uuid1)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBlueCape(UUID uniqueID) {
        for (UUID uuid1 : this.bluecapes) {
            if (!uniqueID.equals(uuid1)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBetaCape(UUID uniqueID) {
        for (UUID uuid1 : this.betatesters) {
            if (!uniqueID.equals(uuid1)) continue;
            return true;
        }
        return false;
    }
}

