/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(EntityLivingBase entity) {
        double sideTheta = (double)entity.field_70761_aq / 57.29577951308232;
        double sideX = Math.cos(sideTheta);
        double sideZ = Math.sin(sideTheta);
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Math.cos(forwardTheta);
        double forwardZ = Math.sin(forwardTheta);
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side) {
            this.forward = forward;
            this.side = side;
        }

        public float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(EntityLivingBase entity, double sideX, double sideZ, double forwardX, double forwardZ) {
            this.prevHeight = this.height;
            this.height = this.settle(entity, entity.field_70165_t + sideX * (double)this.side + forwardX * (double)this.forward, entity.field_70163_u, entity.field_70161_v + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
        }

        private float settle(EntityLivingBase entity, double x, double y, double z, float height) {
            BlockPos pos = new BlockPos(x, y + 0.001, z);
            float dist = this.getDistance(entity.field_70170_p, pos);
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(entity.field_70170_p, pos.func_177977_b()) + (float)y % 1.0f : (float)((double)dist - (1.0 - y % 1.0));
            if (entity.field_70122_E && height <= dist) {
                return height == dist ? height : Math.min(height + 0.3f, dist);
            }
            if (height > 0.0f) {
                return Math.max(height - 0.4f, dist);
            }
            return height;
        }

        private float getDistance(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            AxisAlignedBB aabb = state.func_185890_d((IBlockAccess)world, pos);
            return aabb == null ? 1.0f : 1.0f - Math.min((float)aabb.field_72337_e, 1.0f);
        }
    }
}

