/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces;

import cubex2.mods.morefurnaces.tileentity.TileEntityCopperFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityDiamondFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityGoldFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityNetherrackFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityObsidianFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntitySilverFurnace;
import net.minecraft.util.IStringSerializable;

public enum FurnaceType implements IStringSerializable
{
    IRON(2, 2, 2, 1, 150, 1.25f, "Iron Furnace", TileEntityIronFurnace.class),
    GOLD(4, 5, 4, 1, 80, 2.0f, "Gold Furnace", TileEntityGoldFurnace.class),
    DIAMOND(7, 9, 7, 1, 40, 4.0f, "Diamond Furnace", TileEntityDiamondFurnace.class),
    OBSIDIAN(2, 2, 2, 2, 150, 2.0f, "Obsidian Furnace", TileEntityObsidianFurnace.class),
    NETHERRACK(1, 1, 0, 1, 1800, 1.0f, "Netherrack Furnace", TileEntityNetherrackFurnace.class),
    COPPER(2, 2, 2, 1, 150, 1.25f, "Copper Furnace", TileEntityCopperFurnace.class),
    SILVER(4, 5, 4, 1, 100, 1.75f, "Silver Furnace", TileEntitySilverFurnace.class);

    final int inputSlots;
    final int outputSlots;
    public final int fuelSlots;
    public final int parallelSmelting;
    public final int[] inputSlotIds;
    public final int[] outputSlotIds;
    public final int[] fuelSlotIds;
    public final int speed;
    public final float consumptionRate;
    public final String friendlyName;
    public final Class<? extends TileEntityIronFurnace> clazz;

    private FurnaceType(int inputSlots, int outputSlots, int fuelSlots, int parallelSmelting, int speed, float consumptionRate, String friendlyName, Class<? extends TileEntityIronFurnace> clazz) {
        int i;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.fuelSlots = fuelSlots;
        this.parallelSmelting = parallelSmelting;
        this.inputSlotIds = new int[inputSlots * parallelSmelting];
        this.outputSlotIds = new int[outputSlots * parallelSmelting];
        this.fuelSlotIds = new int[fuelSlots];
        for (i = 0; i < this.inputSlotIds.length; ++i) {
            this.inputSlotIds[i] = i;
        }
        for (i = 0; i < this.fuelSlotIds.length; ++i) {
            this.fuelSlotIds[i] = i + this.inputSlotIds.length;
        }
        for (i = 0; i < this.outputSlotIds.length; ++i) {
            this.outputSlotIds[i] = i + this.inputSlotIds.length + this.fuelSlotIds.length;
        }
        this.speed = speed;
        this.consumptionRate = consumptionRate;
        this.friendlyName = friendlyName;
        this.clazz = clazz;
    }

    public static TileEntityIronFurnace makeEntity(int meta) {
        try {
            TileEntityIronFurnace te = FurnaceType.values()[meta].clazz.newInstance();
            return te;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isInputSlot(int slotId) {
        return FurnaceType.arrayContains(this.inputSlotIds, slotId);
    }

    public boolean isFuelSlot(int slotId) {
        return FurnaceType.arrayContains(this.fuelSlotIds, slotId);
    }

    public boolean isOutputSlot(int slotId) {
        return FurnaceType.arrayContains(this.outputSlotIds, slotId);
    }

    public static boolean arrayContains(int[] i, int i1) {
        for (int i2 : i) {
            if (i2 != i1) continue;
            return true;
        }
        return false;
    }

    public int getNumInputSlots() {
        return this.parallelSmelting * this.inputSlots;
    }

    public int getNumFuelSlots() {
        return this.fuelSlots;
    }

    public int getNumOutputSlots() {
        return this.parallelSmelting * this.outputSlots;
    }

    public int getFirstInputSlot(int id) {
        return 0 + id * this.inputSlots;
    }

    public int getLastInputSlot(int id) {
        return this.getFirstInputSlot(id) + this.inputSlots - 1;
    }

    public int getFirstFuelSlot() {
        return this.getLastInputSlot(this.parallelSmelting - 1) + 1;
    }

    public int getLastFuelSlot() {
        return this.getFirstFuelSlot() + this.fuelSlots - 1;
    }

    public int getFirstOutputSlot(int id) {
        return this.getLastFuelSlot() + 1 + id * this.outputSlots;
    }

    public int getLastOutputSlot(int id) {
        return this.getFirstOutputSlot(id) + this.outputSlots - 1;
    }

    public int getNumSlots() {
        return this.parallelSmelting * (this.inputSlots + this.outputSlots) + this.fuelSlots;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }
}

