/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.world.gen.components;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.dungeon.BlockDungeonBase;
import com.legacy.aether.blocks.util.EnumStoneType;
import com.legacy.aether.world.gen.AetherGenUtils;
import com.legacy.aether.world.gen.AetherStructure;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComponentGoldenIsland
extends AetherStructure {
    public ComponentGoldenIsland() {
    }

    public ComponentGoldenIsland(int chunkX, int chunkZ) {
        this.func_186164_a(EnumFacing.NORTH);
        this.field_74887_e = new StructureBoundingBox(chunkX, 110, chunkZ, chunkX + 100, 146, chunkZ + 100);
    }

    @Override
    public boolean generate() {
        this.replaceAir = true;
        this.replaceSolid = true;
        this.setStructureOffset(60, 0, 60);
        this.generateBaseIsland();
        return true;
    }

    public void generateBaseIsland() {
        int i1 = 0;
        int j1 = 21;
        for (int k1 = -j1; k1 <= j1; ++k1) {
            for (int l1 = 24; l1 >= -j1; --l1) {
                for (int k2 = -j1; k2 <= j1; ++k2) {
                    IBlockState state = this.getBlockStateWithOffset(k1, l1, k2);
                    if (state != BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)) || ++i1 <= 12) continue;
                    return;
                }
            }
        }
        for (int i2 = -24; i2 <= 24; ++i2) {
            for (int l2 = 24; l2 >= -24; --l2) {
                for (int i3 = -24; i3 <= 24; ++i3) {
                    int k3 = MathHelper.func_76128_c((double)((double)(i2 * (1 + l2 / 240)) / 0.8));
                    int i4 = l2;
                    if (l2 > 15) {
                        i4 = MathHelper.func_76128_c((double)((double)i4 * 1.375));
                        i4 -= 6;
                    } else if (l2 < -15) {
                        i4 = MathHelper.func_76128_c((double)((double)i4 * (double)1.35f));
                        i4 += 6;
                    }
                    int k4 = MathHelper.func_76128_c((double)((double)(i3 * (1 + l2 / 240)) / 0.8));
                    if (!(Math.sqrt(k3 * k3 + i4 * i4 + k4 * k4) <= 24.0)) continue;
                    if (BlocksAether.isGood(this.getBlockStateWithOffset(i2, l2 + 1, i3)) && l2 > 4) {
                        this.setBlockWithOffset(i2, l2, i3, BlocksAether.aether_grass.func_176223_P());
                        this.setBlockWithOffset(i2, l2 - 1, i3, BlocksAether.aether_dirt.func_176223_P());
                        this.setBlockWithOffset(i2, l2 - (1 + this.random.nextInt(2)), i3, BlocksAether.aether_dirt.func_176223_P());
                        if (l2 < 12) continue;
                        int j5 = this.random.nextInt(48);
                        if (j5 < 2) {
                            AetherGenUtils.generateGoldenOakTree(this, i2, l2 + 1, i3);
                            continue;
                        }
                        if (j5 == 3) {
                            if (this.random.nextInt(2) != 0) continue;
                            continue;
                        }
                        if (j5 != 4) continue;
                        if (this.random.nextInt(2) == 0) {
                            AetherGenUtils.generateFlower(this, Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY), i2 + this.random.nextInt(3) - this.random.nextInt(3), l2 + 1, i3 + this.random.nextInt(3) - this.random.nextInt(3));
                            continue;
                        }
                        AetherGenUtils.generateFlower(this, Blocks.field_150327_N.func_176223_P().func_177226_a(Blocks.field_150327_N.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.DANDELION), i2 + this.random.nextInt(3) - this.random.nextInt(3), l2 + 1, i3 + this.random.nextInt(3) - this.random.nextInt(3));
                        continue;
                    }
                    if (!BlocksAether.isGood(this.getBlockStateWithOffset(i2, l2, i3))) continue;
                    this.setBlockWithOffset(i2, l2, i3, BlocksAether.holystone.func_176223_P());
                }
            }
        }
        int l3 = MathHelper.func_76128_c((double)18.0);
        for (int j4 = 0; j4 < l3; ++j4) {
            int i5 = this.random.nextInt(24) - this.random.nextInt(24);
            int l5 = this.random.nextInt(24) - this.random.nextInt(24);
            int j6 = this.random.nextInt(24) - this.random.nextInt(24);
            this.generateCaves(i5, l5, j6, 24 + l3 / 3);
        }
    }

    public void generateCaves(int x, int y, int z, int size) {
        float f = this.random.nextFloat() * 3.141593f;
        double d = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)size / 8.0f;
        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)size / 8.0f;
        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)size / 8.0f;
        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)size / 8.0f;
        double d4 = y + this.random.nextInt(3) + 2;
        double d5 = y + this.random.nextInt(3) + 2;
        for (int l = 0; l <= size; ++l) {
            double d6 = d + (d1 - d) * (double)l / (double)size;
            double d7 = d4 + (d5 - d4) * (double)l / (double)size;
            double d8 = d2 + (d3 - d2) * (double)l / (double)size;
            double d9 = this.random.nextDouble() * (double)size / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * 3.141593f / (float)size)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * 3.141593f / (float)size)) + 1.0f) * d9 + 1.0;
            int i1 = (int)(d6 - d10 / 2.0);
            int j1 = (int)(d7 - d11 / 2.0);
            int k1 = (int)(d8 - d10 / 2.0);
            int l1 = (int)(d6 + d10 / 2.0);
            int i2 = (int)(d7 + d11 / 2.0);
            int j2 = (int)(d8 + d10 / 2.0);
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        Block block = this.getBlockStateWithOffset(k2, l2, i3).func_177230_c();
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || block != BlocksAether.mossy_holystone && block != BlocksAether.holystone && block != BlocksAether.aether_grass && block != BlocksAether.aether_dirt) continue;
                        this.setBlockWithOffset(k2, l2, i3, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
    }
}

