/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.world.gen;

import com.google.common.collect.Sets;
import com.legacy.aether.world.gen.components.ComponentSilverDungeon;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenSilverDungeon
extends MapGenStructure {
    public String func_143025_a() {
        return "SilverDungeon";
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        int j = pos.func_177958_n() >> 4;
        int k = pos.func_177952_p() >> 4;
        for (int l = 0; l <= 1000; ++l) {
            for (int i1 = -l; i1 <= l; ++i1) {
                boolean flag = i1 == -l || i1 == l;
                for (int j1 = -l; j1 <= l; ++j1) {
                    int l1;
                    int k1;
                    boolean flag1;
                    boolean bl = flag1 = j1 == -l || j1 == l;
                    if (!flag && !flag1 || !this.func_75047_a(k1 = j + i1, l1 = k + j1) || findUnexplored && worldIn.func_190526_b(k1, l1)) continue;
                    return new BlockPos((k1 << 4) + 8, 64, (l1 << 4) + 8);
                }
            }
        }
        return null;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX >> 4;
        int j = chunkZ >> 4;
        this.field_75038_b.setSeed((long)(i ^ j << 4) ^ this.field_75039_c.func_72905_C());
        this.field_75038_b.nextInt();
        if (this.field_75038_b.nextInt(4) != 0) {
            return false;
        }
        if (chunkX != (i << 4) + 4 + this.field_75038_b.nextInt(8)) {
            return false;
        }
        return chunkZ == (j << 4) + 4 + this.field_75038_b.nextInt(8);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private final Set<ChunkPos> processed = Sets.newHashSet();
        private boolean wasCreated;
        private int firstStaircaseZ;
        private int secondStaircaseZ;
        private int finalStaircaseZ;
        private int xTendency;
        private int zTendency;

        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(worldIn, random, chunkX, chunkZ);
        }

        private void create(World worldIn, Random random, int chunkX, int chunkZ) {
            random.setSeed(worldIn.func_72905_C());
            long i = random.nextLong();
            long j = random.nextLong();
            long k = (long)chunkX * i;
            long l = (long)chunkZ * j;
            random.setSeed(k ^ l ^ worldIn.func_72905_C());
            ComponentSilverDungeon dungeon = new ComponentSilverDungeon((chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.firstStaircaseZ = random.nextInt(3);
            this.secondStaircaseZ = random.nextInt(3);
            this.finalStaircaseZ = random.nextInt(3);
            this.xTendency = random.nextInt(3) - 1;
            this.zTendency = random.nextInt(3) - 1;
            dungeon.setStaircasePosition(this.firstStaircaseZ, this.secondStaircaseZ, this.finalStaircaseZ);
            dungeon.setCloudTendencies(this.xTendency, this.zTendency);
            this.field_75075_a.add(dungeon);
            this.func_75072_c();
            this.wasCreated = true;
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            if (!this.wasCreated) {
                this.field_75075_a.clear();
                this.create(worldIn, rand, this.func_143019_e(), this.func_143018_f());
            }
            super.func_75068_a(worldIn, rand, structurebb);
        }

        public boolean func_175788_a(ChunkPos pair) {
            return this.processed.contains(pair) ? false : super.func_175788_a(pair);
        }

        public void func_175787_b(ChunkPos pair) {
            super.func_175787_b(pair);
            this.processed.add(pair);
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            NBTTagList nbttaglist = new NBTTagList();
            for (ChunkPos chunkpos : this.processed) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("X", chunkpos.field_77276_a);
                nbttagcompound.func_74768_a("Z", chunkpos.field_77275_b);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            tagCompound.func_74782_a("Processed", (NBTBase)nbttaglist);
            tagCompound.func_74768_a("firstStaircaseZ", this.firstStaircaseZ);
            tagCompound.func_74768_a("secondStaircaseZ", this.secondStaircaseZ);
            tagCompound.func_74768_a("finalStaircaseZ", this.finalStaircaseZ);
            tagCompound.func_74768_a("xTendency", this.xTendency);
            tagCompound.func_74768_a("zTendency", this.zTendency);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            if (tagCompound.func_150297_b("Processed", 9)) {
                NBTTagList nbttaglist = tagCompound.func_150295_c("Processed", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    this.processed.add(new ChunkPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Z")));
                }
            }
            this.firstStaircaseZ = tagCompound.func_74762_e("firstStaircaseZ");
            this.secondStaircaseZ = tagCompound.func_74762_e("secondStaircaseZ");
            this.finalStaircaseZ = tagCompound.func_74762_e("finalStaircaseZ");
            this.xTendency = tagCompound.func_74762_e("zTendency");
            this.zTendency = tagCompound.func_74762_e("zTendency");
        }
    }
}

