/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.util;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.entities.passive.EntityAetherAnimal;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityMountable
extends EntityAetherAnimal {
    public static final DataParameter<Boolean> RIDER_SNEAKING = EntityDataManager.func_187226_a(EntityMountable.class, (DataSerializer)DataSerializers.field_187198_h);
    protected float jumpPower;
    protected boolean mountJumping;
    protected boolean playStepSound = false;
    protected boolean canJumpMidAir = false;

    public EntityMountable(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIDER_SNEAKING, (Object)false);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean isRiderSneaking() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDER_SNEAKING);
    }

    public void setRiderSneaking(boolean riderSneaking) {
        this.field_70180_af.func_187227_b(RIDER_SNEAKING, (Object)riderSneaking);
    }

    public void func_70071_h_() {
        this.updateRider();
        super.func_70071_h_();
        if (this.func_184207_aI() && this.func_184218_aH()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_184210_p();
            }
        }
    }

    public void updateRider() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_184207_aI()) {
            Entity passenger = (Entity)this.func_184188_bt().get(0);
            if (passenger.func_70093_af()) {
                if (this.field_70122_E) {
                    passenger.func_70095_a(false);
                    passenger.func_184210_p();
                    return;
                }
                this.setRiderSneaking(true);
            } else {
                this.setRiderSneaking(false);
            }
            passenger.func_70095_a(false);
        }
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.field_70126_B = this.field_70177_z = player.field_70177_z;
            this.field_70127_C = this.field_70125_A = player.field_70125_A;
            this.field_70759_as = player.field_70759_as;
            strafe = player.field_70702_br;
            vertical = player.field_70701_bs;
            forward = player.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            double d01 = player.field_70165_t - this.field_70165_t;
            double d2 = player.field_70161_v - this.field_70161_v;
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d01) * 57.29577951308232) - 90.0f;
            if (player.field_70702_br != 0.0f && player.field_70170_p.field_72995_K) {
                this.field_70177_z = this.updateRotation(this.field_70177_z, f, 40.0f);
            }
            if (AetherAPI.getInstance().get(player).isJumping()) {
                this.onMountedJump(strafe, forward);
            }
            if (this.jumpPower > 0.0f && !this.isMountJumping() && (this.field_70122_E || this.canJumpMidAir)) {
                this.field_70181_x = this.getMountJumpStrength() * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setMountJumping(true);
                this.field_70160_al = true;
                this.jumpPower = 0.0f;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
            this.field_70159_w *= (double)0.35f;
            this.field_70179_y *= (double)0.35f;
            this.field_70138_W = 1.0f;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70747_aH = this.func_70689_ay() * 0.6f;
                super.func_191986_a(strafe, vertical, forward);
            }
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.setMountJumping(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public float func_70689_ay() {
        return this.getMountedMoveSpeed();
    }

    public float getMountedMoveSpeed() {
        return 0.15f;
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
    }

    protected double getMountJumpStrength() {
        return 1.0;
    }

    protected void setMountJumping(boolean mountJumping) {
        this.mountJumping = mountJumping;
    }

    protected boolean isMountJumping() {
        return this.mountJumping;
    }

    public void onMountedJump(float par1, float par2) {
        this.jumpPower = 0.4f;
    }
}

