/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish.monitor;

import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import troy.autofish.Autofish;
import troy.autofish.monitor.FishMonitorMP;

public class FishMonitorMPMotion
implements FishMonitorMP {
    public static final int PACKET_MOTION_Y_THRESHOLD = -350;
    private boolean catchable = false;
    private long catchableAt = 0L;
    private boolean hasHitWater = false;

    @Override
    public void hookTick(Autofish autofish, Minecraft minecraft, FishingBobberEntity hook) {
        if (FishMonitorMPMotion.worldContainsBlockWithMaterial(hook.field_70170_p, hook.func_174813_aQ(), Material.field_151586_h)) {
            this.hasHitWater = true;
        }
    }

    @Override
    public void handleHookRemoved() {
        this.hasHitWater = false;
    }

    @Override
    public void handlePacket(Autofish autofish, IPacket<?> packet, Minecraft minecraft) {
        if (packet instanceof SEntityVelocityPacket) {
            SEntityVelocityPacket velocityPacket = (SEntityVelocityPacket)packet;
            if (minecraft.field_71439_g != null && minecraft.field_71439_g.field_71104_cf != null && minecraft.field_71439_g.field_71104_cf.func_145782_y() == velocityPacket.func_149412_c()) {
                if (this.hasHitWater && !this.catchable && velocityPacket.func_149410_e() > 0) {
                    this.catchable = true;
                    this.catchableAt = autofish.timeMillis;
                }
                if (this.hasHitWater && this.catchable && autofish.timeMillis - this.catchableAt > 500L && velocityPacket.func_149411_d() == 0 && velocityPacket.func_149409_f() == 0 && velocityPacket.func_149410_e() < -350) {
                    autofish.catchFish();
                    this.hasHitWater = false;
                }
            }
        }
    }

    public static boolean worldContainsBlockWithMaterial(World world, AxisAlignedBB box, Material material) {
        int i = MathHelper.func_76128_c((double)box.field_72340_a);
        int j = MathHelper.func_76143_f((double)box.field_72336_d);
        int k = MathHelper.func_76128_c((double)box.field_72338_b);
        int l = MathHelper.func_76143_f((double)box.field_72337_e);
        int m = MathHelper.func_76128_c((double)box.field_72339_c);
        int n = MathHelper.func_76143_f((double)box.field_72334_f);
        BlockMaterialMatcher materialPredicate = BlockMaterialMatcher.func_189886_a((Material)material);
        return BlockPos.func_218287_a((int)i, (int)k, (int)m, (int)(j - 1), (int)(l - 1), (int)(n - 1)).anyMatch(blockPos -> materialPredicate.test(world.func_180495_p(blockPos)));
    }
}

