/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import troy.autofish.ForgeModAutofish;
import troy.autofish.config.Config;

public class ConfigManager {
    private Config config;
    private ForgeModAutofish modAutofish;
    private Gson gson;
    private File configFile;
    private Executor executor = Executors.newSingleThreadExecutor();

    public ConfigManager(ForgeModAutofish modAutofish) {
        this.modAutofish = modAutofish;
        this.gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
        this.configFile = new File(FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).toFile(), "autofish.config");
        this.readConfig(false);
    }

    public void readConfig(boolean async) {
        Runnable task = () -> {
            try {
                if (this.configFile.exists()) {
                    String fileContents = FileUtils.readFileToString((File)this.configFile, (Charset)Charset.defaultCharset());
                    this.config = (Config)this.gson.fromJson(fileContents, Config.class);
                    if (this.config.enforceConstraints()) {
                        this.writeConfig(true);
                    }
                } else {
                    this.writeNewConfig();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writeNewConfig();
            }
        };
        if (async) {
            this.executor.execute(task);
        } else {
            task.run();
        }
    }

    public void writeNewConfig() {
        this.config = new Config();
        this.writeConfig(false);
    }

    public void writeConfig(boolean async) {
        Runnable task = () -> {
            try {
                if (this.config != null) {
                    String serialized = this.gson.toJson((Object)this.config);
                    FileUtils.writeStringToFile((File)this.configFile, (String)serialized, (Charset)Charset.defaultCharset());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        if (async) {
            this.executor.execute(task);
        } else {
            task.run();
        }
    }

    public Config getConfig() {
        return this.config;
    }
}

