/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.torocraft.torohealth.bars.HealthBarRenderer;

public class BarDisplay {
    private static final ResourceLocation ICON_TEXTURES = new ResourceLocation("textures/gui/icons.png");
    private final Minecraft mc;
    private final AbstractGui gui;

    public BarDisplay(Minecraft mc, AbstractGui gui) {
        this.mc = mc;
        this.gui = gui;
    }

    private String getEntityName(LivingEntity entity) {
        return entity.func_145748_c_().getString();
    }

    public void drawStringWithShadow(MatrixStack matrices, FontRenderer textRenderer, String text, int x, int y, int color) {
        AbstractGui.func_238476_c_((MatrixStack)matrices, (FontRenderer)textRenderer, (String)text, (int)x, (int)y, (int)color);
    }

    public int drawWithShadow(MatrixStack matrices, String text, float x, float y, int color) {
        return this.mc.field_71466_p.func_238421_b_(matrices, text, x, y, color);
    }

    public void draw(MatrixStack matrix, LivingEntity entity) {
        int xOffset = 0;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        HealthBarRenderer.render(matrix, entity, 63.0, 14.0, 130.0f, false);
        String name = this.getEntityName(entity);
        String health = (int)Math.ceil(entity.func_110143_aJ()) + "/" + (int)entity.func_110138_aP();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawStringWithShadow(matrix, this.mc.field_71466_p, name, xOffset, 2, 0xFFFFFF);
        this.drawWithShadow(matrix, name, xOffset, 2.0f, 0xFFFFFF);
        this.renderHeartIcon(matrix, xOffset += this.mc.field_71466_p.func_78256_a(name) + 5, 1);
        this.drawWithShadow(matrix, health, xOffset += 10, 2.0f, 0xE0E0E0);
        xOffset += this.mc.field_71466_p.func_78256_a(health) + 5;
        int armor = entity.func_70658_aO();
        if (armor > 0) {
            this.renderArmorIcon(matrix, xOffset, 1);
            this.drawWithShadow(matrix, armor + "", xOffset += 10, 2.0f, 0xE0E0E0);
        }
    }

    private void renderArmorIcon(MatrixStack matrix, int x, int y) {
        this.mc.func_110434_K().func_110577_a(ICON_TEXTURES);
        this.gui.func_238474_b_(matrix, x, y, 34, 9, 9, 9);
    }

    private void renderHeartIcon(MatrixStack matrix, int x, int y) {
        this.mc.func_110434_K().func_110577_a(ICON_TEXTURES);
        this.gui.func_238474_b_(matrix, x, y, 52, 0, 9, 9);
    }
}

