/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.entity.RiftAttachment;
import com.mushroom.midnight.common.entity.RiftBridge;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModDimensions;
import com.mushroom.midnight.common.util.WorldUtil;
import com.mushroom.midnight.common.world.BridgeManager;
import com.mushroom.midnight.common.world.GlobalBridgeManager;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RiftSpawnHandler {
    private static final double RIFT_SEPARATION = 64.0;
    private static final double PLAYER_SEPARATION = 16.0;
    private static final int REGION_RANGE = 2;
    private static boolean warnedOverworldUnloaded;

    public static void update() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            if (!warnedOverworldUnloaded) {
                Midnight.LOGGER.warn("Overworld unloaded! Cannot spawn Midnight rifts");
                warnedOverworldUnloaded = true;
            }
            return;
        }
        if (!world.func_82736_K().func_82766_b("doRiftSpawning")) {
            return;
        }
        WorldServer endpointWorld = DimensionManager.getWorld((int)ModDimensions.MIDNIGHT.func_186068_a());
        if (!world.func_72935_r()) {
            Random random = world.field_73012_v;
            Set<BlockPos> spawnRegions = RiftSpawnHandler.collectPlayerRegions(world.field_73010_i);
            if (endpointWorld != null) {
                spawnRegions.addAll(RiftSpawnHandler.collectPlayerRegions(endpointWorld.field_73010_i));
            }
            for (BlockPos spawnRegion : spawnRegions) {
                if (random.nextInt(MidnightConfig.general.riftSpawnRarity) != 0) continue;
                BlockPos riftPosition = RiftSpawnHandler.generateRiftPosition(random, spawnRegion);
                if (endpointWorld != null && world.func_175723_af().func_177746_a(riftPosition) != endpointWorld.func_175723_af().func_177746_a(riftPosition)) continue;
                if (world.func_175667_e(riftPosition)) {
                    RiftSpawnHandler.trySpawnRift((World)world, riftPosition);
                    continue;
                }
                if (endpointWorld == null || !endpointWorld.func_175667_e(riftPosition)) continue;
                RiftSpawnHandler.trySpawnRift((World)endpointWorld, riftPosition);
            }
        }
    }

    private static Set<BlockPos> collectPlayerRegions(List<EntityPlayer> players) {
        HashSet<BlockPos> spawnRegions = new HashSet<BlockPos>();
        for (EntityPlayer player : players) {
            int regionX = (int)player.field_70165_t >> 5;
            int regionY = (int)player.field_70163_u >> 5;
            int regionZ = (int)player.field_70161_v >> 5;
            for (BlockPos pos : BlockPos.func_191532_a((int)(regionX - 2), (int)(regionY - 2), (int)(regionZ - 2), (int)(regionX + 2), (int)(regionY + 2), (int)(regionZ + 2))) {
                spawnRegions.add(pos);
            }
        }
        return spawnRegions;
    }

    private static void trySpawnRift(World world, BlockPos riftPosition) {
        if (world.func_175623_d(riftPosition)) {
            BlockPos correctedPosition = WorldUtil.findSurface(world, riftPosition, 6);
            if (correctedPosition == null || !RiftSpawnHandler.canRiftSpawn(world, correctedPosition)) {
                return;
            }
            RiftSpawnHandler.spawnRift(world, correctedPosition);
        }
    }

    private static void spawnRift(World world, BlockPos pos) {
        float yaw = world.field_73012_v.nextFloat() * 360.0f;
        RiftAttachment attachment = new RiftAttachment(pos, yaw);
        BridgeManager trackerHandler = GlobalBridgeManager.getServer();
        RiftBridge bridge = trackerHandler.createBridge(attachment);
        EntityRift rift = new EntityRift(world);
        rift.acceptBridge(bridge);
        bridge.getAttachment().apply(rift);
        trackerHandler.addBridge(bridge);
        world.func_72838_d((Entity)rift);
    }

    private static boolean canRiftSpawn(World world, BlockPos pos) {
        if (world.func_175636_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 16.0)) {
            return false;
        }
        AxisAlignedBB riftBounds = new AxisAlignedBB(pos).func_186662_g(64.0);
        if (!world.func_72872_a(EntityRift.class, riftBounds).isEmpty()) {
            return false;
        }
        AxisAlignedBB bounds = new AxisAlignedBB(pos).func_72314_b(1.0, 0.0, 1.0).func_72321_a(0.0, 1.0, 0.0);
        if (!world.func_184144_a(null, bounds).isEmpty()) {
            return false;
        }
        return Helper.isMidnightDimension(world) || !world.func_72953_d(bounds) && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 4;
    }

    private static BlockPos generateRiftPosition(Random random, BlockPos region) {
        int x = (region.func_177958_n() << 5) + random.nextInt(32);
        int y = (region.func_177956_o() << 5) + random.nextInt(32);
        int z = (region.func_177952_p() << 5) + random.nextInt(32);
        return new BlockPos(x, y, z);
    }
}

