/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import com.mushroom.midnight.Midnight;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityReference<T extends Entity> {
    private final World world;
    @Nullable
    private UUID entityId;
    @Nullable
    private WeakReference<T> cachedEntity;
    private long lastLookupTime;

    public EntityReference(World world) {
        this.world = world;
    }

    public void set(T entity) {
        this.entityId = entity.func_110124_au();
        this.cachedEntity = new WeakReference<T>(entity);
    }

    public Optional<T> deref(boolean forceLoad) {
        if (this.entityId == null) {
            return Optional.empty();
        }
        T cached = this.getCachedEntity();
        if (cached != null && !cached.func_70089_S()) {
            this.cachedEntity = null;
            return Optional.empty();
        }
        if (cached != null) {
            return Optional.of(cached);
        }
        long totalWorldTime = this.world.func_82737_E();
        if (forceLoad || totalWorldTime - this.lastLookupTime > 20L) {
            Optional<Entity> entity = this.world.field_72996_f.stream().filter(e -> e.func_110124_au().equals(this.entityId)).findFirst();
            entity.ifPresent(this::updateCachedEntity);
            this.lastLookupTime = totalWorldTime;
        }
        return Optional.ofNullable(this.getCachedEntity());
    }

    public boolean isPresent() {
        return this.deref(false).isPresent();
    }

    private void updateCachedEntity(Entity entity) {
        try {
            this.cachedEntity = new WeakReference<Entity>(entity);
        }
        catch (ClassCastException e) {
            Midnight.LOGGER.warn("Entity contained reference to entity of unexpected type! {}", (Object)entity);
            this.cachedEntity = null;
        }
    }

    @Nullable
    private T getCachedEntity() {
        return (T)(this.cachedEntity != null ? (Entity)this.cachedEntity.get() : null);
    }

    public NBTTagCompound serialize(NBTTagCompound compound) {
        if (this.entityId != null) {
            compound.func_74778_a("uuid", this.entityId.toString());
        }
        return compound;
    }

    public void deserialize(NBTTagCompound compound) {
        this.entityId = compound.func_150297_b("uuid", 8) ? UUID.fromString(compound.func_74779_i("uuid")) : null;
    }
}

