/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.client.particle.RiftParticleSystem;
import com.mushroom.midnight.common.capability.RiftTravelCooldown;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.IRiftTraveler;
import com.mushroom.midnight.common.entity.RiftAttachment;
import com.mushroom.midnight.common.entity.RiftBridge;
import com.mushroom.midnight.common.entity.RiftGeometry;
import com.mushroom.midnight.common.entity.RiftTravelEntry;
import com.mushroom.midnight.common.entity.creature.EntityHunter;
import com.mushroom.midnight.common.entity.creature.EntityRifter;
import com.mushroom.midnight.common.helper.Helper;
import com.mushroom.midnight.common.registry.ModDimensions;
import com.mushroom.midnight.common.registry.ModSounds;
import com.mushroom.midnight.common.world.BridgeManager;
import com.mushroom.midnight.common.world.GlobalBridgeManager;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityRift
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int OPEN_TIME = 20;
    public static final int CLOSE_SPEED = 2;
    public static final int CLOSE_TIME = 10;
    public static final int UNSTABLE_TIME = 110;
    public static final int LIFETIME = 4000;
    public static final float PULL_RADIUS = 8.0f;
    public static final float PULL_INTENSITY = 5.0f;
    public static final double MAX_PULL_VELOCITY = 1.2;
    private RiftGeometry geometry;
    private RiftBridge bridge;
    private RiftParticleSystem particleSystem;
    private boolean wasStable = true;
    private int spawnedRifters = 0;
    private int failedSpawn = 0;
    private boolean invalid;

    public EntityRift(World world) {
        super(world);
        this.func_70105_a(1.8f, 4.0f);
        this.field_70145_X = true;
        this.initGeometry(new Random().nextLong());
        this.field_70178_ae = true;
        if (world.field_72995_K) {
            this.particleSystem = new RiftParticleSystem(this);
        }
    }

    private void initGeometry(long seed) {
        this.geometry = new RiftGeometry(seed, this.field_70130_N, this.field_70131_O);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.invalid) {
            this.func_70106_y();
            return;
        }
        RiftBridge bridge = this.getBridge();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (!bridge.exists) {
                this.func_70106_y();
                return;
            }
            if (!Helper.isMidnightDimension(this.field_70170_p)) {
                this.updateOverworldBehavior();
            }
            if (bridge.open.getTimer() >= 20 && !this.wasUsed()) {
                this.teleportEntities();
            }
            if (this.wasStable && bridge.unstable.get()) {
                this.func_184185_a(ModSounds.RIFT_UNSTABLE, 1.0f, 1.0f);
                this.wasStable = false;
            }
        } else if (this.particleSystem != null) {
            this.particleSystem.updateParticles(this.field_70170_p.field_73012_v);
        }
    }

    public void acceptBridge(RiftBridge riftBridge) {
        this.bridge = riftBridge;
        this.bridge.accept(this);
    }

    private void updateOverworldBehavior() {
        if (this.field_70170_p.func_72935_r() || this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, this.func_180425_c()) > 5) {
            this.getBridge().unstable.set(true);
        }
        if (this.isUnstable() && !this.wasUsed()) {
            this.pullEntities();
        }
        if (this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning") && !this.isUnstable() && MidnightConfig.general.rifterSpawnRarity > 0 && this.spawnedRifters < MidnightConfig.general.maxRifterByRift && this.field_70170_p.field_73012_v.nextInt(MidnightConfig.general.rifterSpawnRarity) == 0) {
            if (this.trySpawnRifter()) {
                ++this.spawnedRifters;
                this.failedSpawn = 0;
            } else if (++this.failedSpawn > 5) {
                this.spawnedRifters = MidnightConfig.general.maxRifterByRift;
            }
        }
    }

    private boolean trySpawnRifter() {
        EntityMob entity;
        boolean isHunter;
        float theta = (float)((double)this.field_70170_p.field_73012_v.nextFloat() * Math.PI * 2.0);
        float offsetX = -MathHelper.func_76126_a((float)theta) * this.field_70130_N * 0.9f;
        float offsetZ = MathHelper.func_76134_b((float)theta) * this.field_70130_N * 0.9f;
        boolean bl = isHunter = this.field_70146_Z.nextFloat() < 0.01f;
        if (isHunter) {
            entity = new EntityHunter(this.field_70170_p);
            isHunter = true;
        } else {
            entity = new EntityRifter(this.field_70170_p);
            ((EntityRifter)entity).spawnedThroughRift = true;
        }
        entity.func_70080_a(this.field_70165_t + (double)offsetX, this.field_70163_u, this.field_70161_v + (double)offsetZ, (float)Math.toDegrees(theta), 0.0f);
        if (entity.func_70058_J()) {
            this.field_70170_p.func_72838_d((Entity)entity);
            if (isHunter) {
                this.spawnedRifters = MidnightConfig.general.maxRifterByRift;
            }
            return true;
        }
        return false;
    }

    private void pullEntities() {
        double pullIntensity = this.getPullIntensity();
        AxisAlignedBB pullBounds = this.func_174813_aQ().func_186662_g(8.0);
        List entities = this.field_70170_p.func_72839_b((Entity)this, pullBounds);
        for (Entity entity : entities) {
            if (entity instanceof EntityRift) continue;
            this.pullEntity(pullIntensity, entity);
        }
    }

    public void pullEntity(double pullIntensity, Entity entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
            return;
        }
        double deltaX = this.field_70165_t - entity.field_70165_t;
        double deltaY = this.field_70163_u + (double)(this.field_70131_O / 2.0f) - (entity.field_70163_u + (double)(entity.field_70131_O / 2.0f));
        double deltaZ = this.field_70161_v - entity.field_70161_v;
        double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (distanceSq > 0.0) {
            double velocityZ;
            double velocityY;
            double intensity;
            double distance = Math.sqrt(distanceSq);
            double velocityX = entity.field_70159_w + deltaX / distance * (intensity = MathHelper.func_151237_a((double)(pullIntensity / distanceSq), (double)0.0, (double)1.0));
            Vector3d velocity = new Vector3d(velocityX, velocityY = entity.field_70181_x + deltaY / distance * intensity, velocityZ = entity.field_70179_y + deltaZ / distance * intensity);
            if (velocity.lengthSquared() > 1.44) {
                velocity.normalize();
                velocity.scale(1.2);
            }
            entity.field_70159_w = velocity.x;
            entity.field_70181_x = velocity.y;
            entity.field_70179_y = velocity.z;
            entity.field_70143_R = 0.0f;
        }
    }

    public double getPullIntensity() {
        if (this.wasUsed() || !this.isBridgeValid()) {
            return 0.0;
        }
        return Math.pow((double)this.getBridge().unstable.getTimer() / 110.0, 5.0) * 5.0;
    }

    private void teleportEntities() {
        AxisAlignedBB bounds = this.func_174813_aQ().func_72314_b(-0.4, 0.0, -0.4);
        DimensionType endpointDimension = this.getEndpointDimension();
        List entities = this.field_70170_p.func_175674_a((Entity)this, bounds, entity -> {
            if (entity.func_184218_aH() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
                return false;
            }
            RiftTravelCooldown cooldown = (RiftTravelCooldown)entity.getCapability(Midnight.RIFT_TRAVEL_COOLDOWN_CAP, null);
            if (cooldown != null && !cooldown.isReady()) {
                return false;
            }
            return !(entity instanceof EntityRift);
        });
        Set<RiftTravelEntry> recursedEntities = this.getRecursedTravelers(entities);
        for (RiftTravelEntry entry : recursedEntities) {
            Entity entity2 = entry.getEntity();
            if (entity2 instanceof IRiftTraveler) {
                ((IRiftTraveler)entity2).onEnterRift(this);
            }
            entity2.func_184210_p();
            if (this.shouldTravelThroughRift(entity2)) {
                entry.travel(this, endpointDimension);
                continue;
            }
            entity2.func_70106_y();
        }
    }

    private boolean shouldTravelThroughRift(Entity entity) {
        return this.isEndpointLoaded() || entity instanceof EntityPlayer;
    }

    private Set<RiftTravelEntry> getRecursedTravelers(List<Entity> entities) {
        HashSet<RiftTravelEntry> recursedEntities = new HashSet<RiftTravelEntry>();
        for (Entity entity : entities) {
            if (entity instanceof IRiftTraveler) {
                IRiftTraveler traveler = (IRiftTraveler)entity;
                recursedEntities.add(traveler.createTravelEntry(this));
                recursedEntities.addAll(traveler.getAdditionalTravelers(this));
                continue;
            }
            recursedEntities.add(new RiftTravelEntry(entity));
            for (Entity passenger : entity.func_184182_bu()) {
                recursedEntities.add(new RiftTravelEntry(passenger));
            }
        }
        return recursedEntities;
    }

    public boolean isOpen() {
        if (!this.isBridgeValid()) {
            return false;
        }
        return this.getBridge().open.get();
    }

    public boolean isUnstable() {
        if (!this.isBridgeValid()) {
            return false;
        }
        return this.getBridge().unstable.get();
    }

    public boolean wasUsed() {
        if (!this.isBridgeValid()) {
            return false;
        }
        return this.getBridge().used;
    }

    public RiftGeometry getGeometry() {
        return this.geometry;
    }

    @Nullable
    public RiftParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    public boolean isBridgeValid() {
        return this.bridge != null;
    }

    public RiftBridge getBridge() {
        if (!this.field_70170_p.field_72995_K && this.bridge == null) {
            this.bridge = this.createBridge();
        }
        return this.bridge;
    }

    private RiftBridge createBridge() {
        BridgeManager trackerHandler = GlobalBridgeManager.getServer();
        RiftAttachment attachment = new RiftAttachment(this.func_180425_c(), this.field_70177_z);
        RiftBridge bridge = trackerHandler.createBridge(attachment);
        bridge.accept(this);
        trackerHandler.addBridge(bridge);
        return bridge;
    }

    public DimensionType getEndpointDimension() {
        if (Helper.isMidnightDimension(this.field_70170_p)) {
            return DimensionType.OVERWORLD;
        }
        return ModDimensions.MIDNIGHT;
    }

    public boolean isEndpointLoaded() {
        RiftBridge bridge = this.getBridge();
        if (bridge == null) {
            return false;
        }
        return bridge.isEndpointLoaded(this.getEndpointDimension());
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74772_a("geometry_seed", this.geometry.getSeed());
        compound.func_74768_a("spawned_rifters", this.spawnedRifters);
        compound.func_74768_a("failed_spawn", this.failedSpawn);
        if (this.bridge != null) {
            compound.func_74768_a("bridge_id", this.bridge.getId());
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.initGeometry(compound.func_74763_f("geometry_seed"));
        this.spawnedRifters = compound.func_74762_e("spawned_rifters");
        this.failedSpawn = compound.func_74762_e("failed_spawn");
        if (compound.func_74764_b("bridge_id")) {
            this.invalid = this.initBridge(compound.func_74762_e("bridge_id"));
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.invalid);
        if (!this.invalid) {
            buffer.writeLong(this.geometry.getSeed());
            RiftBridge bridge = this.getBridge();
            buffer.writeInt(bridge.getId());
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.invalid = buffer.readBoolean();
        if (!this.invalid) {
            this.initGeometry(buffer.readLong());
            this.initBridge(buffer.readInt());
        }
    }

    private boolean initBridge(int bridgeId) {
        BridgeManager tracker = GlobalBridgeManager.get(this.field_70170_p.field_72995_K);
        RiftBridge bridge = tracker.getBridge(bridgeId);
        if (bridge == null) {
            if (this.field_70170_p.field_72995_K) {
                bridge = new RiftBridge(bridgeId, new RiftAttachment(this.func_180425_c(), this.field_70177_z));
                GlobalBridgeManager.getClient().addBridge(bridge);
            } else {
                return true;
            }
        }
        this.acceptBridge(bridge);
        return false;
    }
}

