/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.registry.ModTabs;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMidnightSlab
extends BlockSlab
implements IModelProvider {
    private final Supplier<IBlockState> parentSupplier;

    public BlockMidnightSlab(Supplier<IBlockState> parentSupplier) {
        super(Material.field_151576_e);
        this.parentSupplier = parentSupplier;
        this.func_149647_a(ModTabs.BUILDING_TAB);
        this.func_180632_j(this.buildDefaultState(this.field_176227_L.func_177621_b()));
    }

    protected IBlockState buildDefaultState(IBlockState baseState) {
        return baseState.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    public boolean func_176552_j() {
        return false;
    }

    public IProperty<?> func_176551_l() {
        throw new UnsupportedOperationException();
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)(meta == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM ? 0 : 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a});
    }

    public Material func_149688_o(IBlockState state) {
        return this.parentSupplier.get().func_185904_a();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.parentSupplier.get().func_185887_b(world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        IBlockState parentState = this.parentSupplier.get();
        return parentState.func_177230_c().getExplosionResistance(world, pos, exploder, explosion);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        IBlockState parentState = this.parentSupplier.get();
        return parentState.func_177230_c().getSoundType(parentState, world, pos, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        IBlockState parentState = this.parentSupplier.get();
        parentState.func_177230_c().func_180655_c(parentState, world, pos, rand);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.parentSupplier.get().func_185889_a(source, pos);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        IBlockState parentState = this.parentSupplier.get();
        return parentState.func_177230_c().canRenderInLayer(parentState, layer);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.parentSupplier.get().func_177230_c().func_180664_k();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.parentSupplier.get().func_185909_g(world, pos);
    }

    IBlockState getParentstate() {
        return this.parentSupplier.get();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.parentSupplier.get().func_177230_c().getFireSpreadSpeed(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.parentSupplier.get().func_177230_c().getFlammability(world, pos, face);
    }
}

