/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.registry.ModTabs;
import com.mushroom.midnight.common.util.DirectionalBounds;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMidnightFungiShelf
extends Block
implements IModelProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", f -> f != EnumFacing.DOWN);
    private static final DirectionalBounds BOUNDS = new DirectionalBounds(0.0625, 0.3, 1.0, 0.9375, 0.7, 0.6);
    private static final AxisAlignedBB VERTICAL_BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.4, 0.9375);

    public BlockMidnightFungiShelf() {
        super(Material.field_151585_k, MapColor.field_193571_W);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(ModTabs.DECORATION_TAB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockMidnightFungiShelf.canAttachTo(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return Arrays.stream(EnumFacing.field_82609_l).anyMatch(f -> BlockMidnightFungiShelf.canAttachTo(world, pos, f));
    }

    private static boolean canAttachTo(World world, BlockPos pos, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return false;
        }
        BlockPos surfacePos = pos.func_177972_a(facing.func_176734_d());
        IBlockState surfaceState = world.func_180495_p(surfacePos);
        return surfaceState.isSideSolid((IBlockAccess)world, surfacePos, facing);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(BlockMidnightFungiShelf.canAttachTo(world, pos, facing) ? facing : EnumFacing.UP));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.tryDrop(world, pos, state) && !BlockMidnightFungiShelf.canAttachTo(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    private boolean tryDrop(World world, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(world, pos)) {
            return true;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.UP) {
            return VERTICAL_BOUNDS;
        }
        return BOUNDS.get(facing);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing == EnumFacing.DOWN) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }
}

