/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.IModelProvider;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.registry.ModTabs;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockMidnightFungiHat
extends Block
implements IModelProvider {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private final Supplier<Block> saplingSupplier;
    private final Supplier<Item> powderSupplier;

    public BlockMidnightFungiHat(Supplier<Block> saplingSupplier, Supplier<Item> powderSupplier, MapColor mapColor) {
        super(Material.field_151575_d, mapColor);
        this.saplingSupplier = saplingSupplier;
        this.powderSupplier = powderSupplier;
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(ModTabs.BUILDING_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149745_a(Random random) {
        return random.nextInt(5) == 0 ? 1 : 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return rand.nextBoolean() ? Item.func_150898_a((Block)this.saplingSupplier.get()) : this.powderSupplier.get();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.isInside(world, pos.func_177984_a()))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.isInside(world, pos.func_177977_b()))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.isInside(world, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.isInside(world, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.isInside(world, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.isInside(world, pos.func_177976_e())));
    }

    private boolean isInside(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == ModBlocks.MUSHROOM_INSIDE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public static List<EnumFacing> getOuterSides(IBlockState state) {
        ArrayList<EnumFacing> outerSides = new ArrayList<EnumFacing>();
        if (!((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            outerSides.add(EnumFacing.UP);
        }
        if (!((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            outerSides.add(EnumFacing.DOWN);
        }
        if (!((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            outerSides.add(EnumFacing.NORTH);
        }
        if (!((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            outerSides.add(EnumFacing.EAST);
        }
        if (!((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            outerSides.add(EnumFacing.SOUTH);
        }
        if (!((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            outerSides.add(EnumFacing.WEST);
        }
        return outerSides;
    }

    public float func_185485_f(IBlockState state) {
        return 0.8f;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType placementType) {
        return false;
    }
}

