/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mushroom.midnight.common.biome.MidnightBiomeFeatures;
import com.mushroom.midnight.common.biome.cavern.CavernStructureConfig;
import com.mushroom.midnight.common.biome.cavern.CavernousBiomeConfig;
import com.mushroom.midnight.common.biome.config.FeatureConfig;
import com.mushroom.midnight.common.biome.config.SpawnerConfig;
import com.mushroom.midnight.common.biome.config.SurfaceConfig;
import com.mushroom.midnight.common.biome.surface.SurfaceBiomeConfig;
import com.mushroom.midnight.common.biome.surface.SurfaceTerrainConfig;
import com.mushroom.midnight.common.block.BlockSuavis;
import com.mushroom.midnight.common.entity.creature.EntityCrystalBug;
import com.mushroom.midnight.common.entity.creature.EntityDeceitfulSnapper;
import com.mushroom.midnight.common.entity.creature.EntityHunter;
import com.mushroom.midnight.common.entity.creature.EntityNightStag;
import com.mushroom.midnight.common.entity.creature.EntityNova;
import com.mushroom.midnight.common.entity.creature.EntityRifter;
import com.mushroom.midnight.common.entity.creature.EntitySkulk;
import com.mushroom.midnight.common.entity.creature.EntityStinger;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import com.mushroom.midnight.common.world.feature.FeatureSorting;
import com.mushroom.midnight.common.world.feature.IMidnightFeature;
import com.mushroom.midnight.common.world.feature.config.DragonNestPlacementConfig;
import com.mushroom.midnight.common.world.feature.config.IPlacementConfig;
import com.mushroom.midnight.common.world.feature.config.ParcelPlacementConfig;
import com.mushroom.midnight.common.world.feature.config.ScatterPlacementConfig;
import com.mushroom.midnight.common.world.feature.config.SurfacePlacementConfig;
import com.mushroom.midnight.common.world.feature.config.UndergroundPlacementConfig;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class MidnightBiomeConfigs {
    public static final SurfaceConfig ROCKY_SURFACE_CONFIG = new SurfaceConfig().withTopState(ModBlocks.NIGHTSTONE.func_176223_P()).withFillerState(ModBlocks.NIGHTSTONE.func_176223_P()).withWetState(ModBlocks.NIGHTSTONE.func_176223_P());
    public static final FeatureConfig GLOBAL_FEATURE_CONFIG = FeatureConfig.builder().withFeature(FeatureSorting.LAST, MidnightBiomeFeatures.GHOST_PLANT_FEATURE, (IPlacementConfig)new ParcelPlacementConfig(3, 6, 0.3f)).withFeature(FeatureSorting.LAST, MidnightBiomeFeatures.DRAGON_NEST_FEATURE, (IPlacementConfig)new DragonNestPlacementConfig(32, 32)).withFeature(FeatureSorting.LAST, MidnightBiomeFeatures.UNSTABLE_BUSH_FEATURE, (IPlacementConfig)new ParcelPlacementConfig(6, 10, 0.2f)).withFeature(FeatureSorting.LAST, MidnightBiomeFeatures.UNDERGROUND_FEATURES, (IPlacementConfig)new UndergroundPlacementConfig(1, 3, 10, 50)).withFlower(new Biome.FlowerEntry(ModBlocks.GHOST_PLANT.func_176223_P(), 20), new Biome.FlowerEntry(ModBlocks.LUMEN_BUD.func_176223_P(), 20), new Biome.FlowerEntry(ModBlocks.NIGHTSHROOM.func_176223_P(), 5), new Biome.FlowerEntry(ModBlocks.VIRIDSHROOM.func_176223_P(), 5), new Biome.FlowerEntry(ModBlocks.DEWSHROOM.func_176223_P(), 5), new Biome.FlowerEntry(ModBlocks.BOGSHROOM.func_176223_P(), 5)).build();
    public static final FeatureConfig VEGETATED_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(GLOBAL_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.ROCKSHROOM_HEAP_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-99, 1)).withFeature(MidnightBiomeFeatures.TALL_GRASS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(6, 64)).withFeature(MidnightBiomeFeatures.DOUBLE_GRASS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(3, 32)).withFeature(MidnightBiomeFeatures.LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 32)).withFeature(MidnightBiomeFeatures.DOUBLE_LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 16)).withFeature(MidnightBiomeFeatures.FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 16)).build();
    public static final FeatureConfig ROCKY_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(GLOBAL_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.ROCKSHROOM_HEAP_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-99, 1)).withFeature(MidnightBiomeFeatures.LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 16)).withFeature(MidnightBiomeFeatures.DOUBLE_LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 16)).withFeature(MidnightBiomeFeatures.FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 16)).withFeature(MidnightBiomeFeatures.TRENCHSTONE_BOULDER_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-3, 1)).build();
    public static final FeatureConfig VIGILANT_FOREST_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(VEGETATED_FEATURE_CONFIG).withFeature(new IMidnightFeature[]{MidnightBiomeFeatures.SHADOWROOT_TREE_FEATURE, MidnightBiomeFeatures.DARK_WILLOW_TREE_FEATURE}, (IPlacementConfig)new SurfacePlacementConfig(8)).withFeature(MidnightBiomeFeatures.SUAVIS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 8)).withFeature(MidnightBiomeFeatures.DEAD_LOG_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(6)).withFeature(MidnightBiomeFeatures.DEAD_TREE_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-5, 1)).withFeature(MidnightBiomeFeatures.VIOLEAF_FEATURE, (IPlacementConfig)new ParcelPlacementConfig(2, 5, 0.3f)).withFlower(new Biome.FlowerEntry(ModBlocks.VIOLEAF.func_176223_P(), 40), new Biome.FlowerEntry(ModBlocks.SUAVIS.func_176223_P().func_177226_a((IProperty)BlockSuavis.STAGE, (Comparable)Integer.valueOf(0)), 40)).build();
    public static final FeatureConfig RUNEBUSH_GROVE_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(GLOBAL_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 32)).withFeature(MidnightBiomeFeatures.DOUBLE_LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 16)).withFeature(new IMidnightFeature[]{MidnightBiomeFeatures.SHADOWROOT_TREE_FEATURE, MidnightBiomeFeatures.DARK_WILLOW_TREE_FEATURE}, (IPlacementConfig)new SurfacePlacementConfig(8)).withFeature(MidnightBiomeFeatures.DEAD_LOG_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(6)).withFeature(MidnightBiomeFeatures.COMMON_SUAVIS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(8, 8)).withFeature(MidnightBiomeFeatures.RUNEBUSH_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(16, 128)).withFeature(MidnightBiomeFeatures.TALL_GRASS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(4, 16)).withFlower(new Biome.FlowerEntry(ModBlocks.RUNEBUSH.func_176223_P(), 40), new Biome.FlowerEntry(ModBlocks.SUAVIS.func_176223_P().func_177226_a((IProperty)BlockSuavis.STAGE, (Comparable)Integer.valueOf(0)), 40)).build();
    public static final FeatureConfig FUNGI_FOREST_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(VEGETATED_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.ROCKSHROOM_HEAP_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-8, 2)).withFeature(MidnightBiomeFeatures.LARGE_FUNGI_FEATURES, (IPlacementConfig)new SurfacePlacementConfig(6)).withFeature(MidnightBiomeFeatures.FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(6, 16)).withFeature(MidnightBiomeFeatures.DOUBLE_FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(4, 8)).withFeature(MidnightBiomeFeatures.BLADESHROOM_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 32)).withFlower(new Biome.FlowerEntry(ModBlocks.BLADESHROOM.func_176223_P(), 40)).build();
    public static final FeatureConfig CRYSTAL_SPIRES_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(GLOBAL_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.ROCKSHROOM_HEAP_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-99, 1)).withFeature(MidnightBiomeFeatures.SHADOWROOT_TREE_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-3, 1)).withFeature(MidnightBiomeFeatures.BLOOMCRYSTAL_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(3)).withFeature(MidnightBiomeFeatures.BLOOMCRYSTAL_SPIRE_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(2, 3)).withFeature(MidnightBiomeFeatures.LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 32)).withFeature(MidnightBiomeFeatures.DOUBLE_LUMEN_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 16)).withFeature(MidnightBiomeFeatures.CRYSTAL_FLOWER_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(5, 12)).withFlower(new Biome.FlowerEntry(ModBlocks.CRYSTAL_FLOWER.func_176223_P(), 60)).build();
    public static final FeatureConfig WARPED_FIELDS_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(VEGETATED_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.SHADOWROOT_TREE_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-3, 1)).build();
    public static final FeatureConfig DECEITFUL_BOG_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(GLOBAL_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.ROCKSHROOM_HEAP_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-99, 1)).withFeature(MidnightBiomeFeatures.BOG_DEAD_TREE_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-1, 1)).withFeature(new IMidnightFeature[]{MidnightBiomeFeatures.SHADOWROOT_TREE_FEATURE, MidnightBiomeFeatures.DARK_WILLOW_TREE_FEATURE}, (IPlacementConfig)new SurfacePlacementConfig(4)).withFeature(MidnightBiomeFeatures.LARGE_BOGSHROOM_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(1)).withFeature(MidnightBiomeFeatures.BOGWEED_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 24)).withFeature(MidnightBiomeFeatures.TALL_GRASS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(5, 32)).withFeature(MidnightBiomeFeatures.DOUBLE_GRASS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(3, 16)).withFeature(MidnightBiomeFeatures.DECEITFUL_MOSS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(16, 32)).withFeature(MidnightBiomeFeatures.BOG_FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(2, 16)).withFeature(MidnightBiomeFeatures.DOUBLE_BOG_FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(1, 8)).withFeature(MidnightBiomeFeatures.DEAD_LOG_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(5)).withFeature(MidnightBiomeFeatures.DECEITFUL_ALGAE_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(10, 20)).build();
    public static final FeatureConfig NIGHT_PLAINS_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(GLOBAL_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.ROCKSHROOM_HEAP_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-99, 1)).withFeature(MidnightBiomeFeatures.TALL_GRASS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(2, 32)).withFeature(MidnightBiomeFeatures.FINGERED_GRASS_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(8, 16){

        @Override
        public void apply(World world, SurfacePlacementLevel placementLevel, Random random, BlockPos chunkOrigin, Consumer<BlockPos> generator) {
            if (world.field_73012_v.nextFloat() < 0.2f) {
                super.apply(world, placementLevel, random, chunkOrigin, generator);
            }
        }
    }).withFlower(new Biome.FlowerEntry(ModBlocks.FINGERED_GRASS.func_176223_P(), 40)).withFeature(new IMidnightFeature[]{MidnightBiomeFeatures.SHADOWROOT_TREE_FEATURE, MidnightBiomeFeatures.DEAD_TREE_FEATURE}, (IPlacementConfig)new SurfacePlacementConfig(-5, 1)).withFeature(new IMidnightFeature[]{MidnightBiomeFeatures.NIGHTSTONE_BOULDER_FEATURE, MidnightBiomeFeatures.NIGHTSTONE_SPIKE_FEATURE}, (IPlacementConfig)new SurfacePlacementConfig(-3, 1)).build();
    public static final FeatureConfig VALLEY_FEATURE_CONFIG = FeatureConfig.builder().extendsFrom(GLOBAL_FEATURE_CONFIG).withFeature(MidnightBiomeFeatures.ROCKSHROOM_HEAP_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(-99, 1)).build();
    public static final FeatureConfig GREAT_CAVERN_FEATURE_CONFIG = FeatureConfig.builder().withFlower(new Biome.FlowerEntry(ModBlocks.LUMEN_BUD.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.NIGHTSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.VIRIDSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.DEWSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.BOGSHROOM.func_176223_P(), 10)).build();
    public static final FeatureConfig CRYSTAL_CAVERN_FEATURE_CONFIG = FeatureConfig.builder().withFeature(MidnightBiomeFeatures.ROUXE_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(5)).withFlower(new Biome.FlowerEntry(ModBlocks.LUMEN_BUD.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.NIGHTSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.VIRIDSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.DEWSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.BOGSHROOM.func_176223_P(), 10)).build();
    public static final FeatureConfig FUNGAL_CAVERN_FEATURE_CONFIG = FeatureConfig.builder().withFeature(MidnightBiomeFeatures.FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(6, 16)).withFeature(MidnightBiomeFeatures.DOUBLE_FUNGI_FEATURE, (IPlacementConfig)new ScatterPlacementConfig(4, 8)).withFeature(MidnightBiomeFeatures.LARGE_BULB_FUNGUS_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(3)).withFeature(MidnightBiomeFeatures.BULB_FUNGUS_FEATURE, (IPlacementConfig)new SurfacePlacementConfig(5, 8)).withFlower(new Biome.FlowerEntry(ModBlocks.BULB_FUNGUS.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.LUMEN_BUD.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.NIGHTSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.VIRIDSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.DEWSHROOM.func_176223_P(), 10), new Biome.FlowerEntry(ModBlocks.BOGSHROOM.func_176223_P(), 10)).build();
    public static final SpawnerConfig VEGETATED_SPAWN_CONFIG = SpawnerConfig.builder().withCreature(new Biome.SpawnListEntry(EntityNightStag.class, 100, 1, 3)).withMonster(new Biome.SpawnListEntry(EntityRifter.class, 100, 1, 2)).withMonster(new Biome.SpawnListEntry(EntityEnderman.class, 10, 4, 4)).build();
    public static final SpawnerConfig ROCKY_SPAWN_CONFIG = SpawnerConfig.builder().withCreature(new Biome.SpawnListEntry(EntityNightStag.class, 100, 1, 3)).withMonster(new Biome.SpawnListEntry(EntityRifter.class, 100, 1, 2)).withMonster(new Biome.SpawnListEntry(EntityEnderman.class, 10, 4, 4)).withMonster(new Biome.SpawnListEntry(EntityHunter.class, 5, 1, 2)).build();
    public static final SpawnerConfig UNDERGROUND_SPAWN_CONFIG = SpawnerConfig.builder().withMonster(new Biome.SpawnListEntry(EntityStinger.class, 100, 2, 4)).withMonster(new Biome.SpawnListEntry(EntityEnderman.class, 10, 4, 4)).build();
    public static final SpawnerConfig CRYSTAL_SPIRES_SPAWN_CONFIG = SpawnerConfig.builder().withCreature(new Biome.SpawnListEntry(EntityNightStag.class, 100, 1, 3)).withAmbientCreature(new Biome.SpawnListEntry(EntityCrystalBug.class, 100, 7, 10)).withMonster(new Biome.SpawnListEntry(EntityStinger.class, 100, 1, 2)).build();
    public static final SpawnerConfig WARPED_FIELDS_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(VEGETATED_SPAWN_CONFIG).withMonster(new Biome.SpawnListEntry(EntityHunter.class, 5, 0, 2)).build();
    public static final SpawnerConfig VIGILANT_FOREST_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(VEGETATED_SPAWN_CONFIG).withCreature(new Biome.SpawnListEntry(EntitySkulk.class, 100, 1, 2)).build();
    public static final SpawnerConfig FUNGI_FOREST_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(VEGETATED_SPAWN_CONFIG).withCreature(new Biome.SpawnListEntry(EntitySkulk.class, 100, 1, 2)).build();
    public static final SpawnerConfig DECEITFUL_BOG_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(VEGETATED_SPAWN_CONFIG).withWaterCreature(new Biome.SpawnListEntry(EntityDeceitfulSnapper.class, 100, 5, 10)).build();
    public static final SpawnerConfig NIGHT_PLAINS_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(VEGETATED_SPAWN_CONFIG).withMonster(new Biome.SpawnListEntry(EntityHunter.class, 5, 1, 2)).build();
    public static final SpawnerConfig PLATEAU_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(ROCKY_SPAWN_CONFIG).withMonster(new Biome.SpawnListEntry(EntityHunter.class, 5, 0, 2)).build();
    public static final SpawnerConfig VALLEY_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(VEGETATED_SPAWN_CONFIG).withMonster(new Biome.SpawnListEntry(EntityHunter.class, 5, 1, 2)).build();
    public static final SpawnerConfig GREAT_CAVERN_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(UNDERGROUND_SPAWN_CONFIG).build();
    public static final SpawnerConfig CRYSTAL_CAVERN_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(UNDERGROUND_SPAWN_CONFIG).withMonster(new Biome.SpawnListEntry(EntityNova.class, 100, 1, 2)).build();
    public static final SpawnerConfig FUNGAL_CAVERN_SPAWN_CONFIG = SpawnerConfig.builder().extendsFrom(UNDERGROUND_SPAWN_CONFIG).build();
    public static final SurfaceTerrainConfig WARPED_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(0.1f).withHeightVariation(0.8f).withDensityScale(0.5f).withRidgeWeight(0.0f).wet();
    public static final SurfaceTerrainConfig BOG_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(-0.9f).withHeightVariation(0.2f).withRidgeWeight(0.0f).wet();
    public static final SurfaceTerrainConfig PLAINS_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(0.12f).withHeightVariation(0.26f).withRidgeWeight(0.0f);
    public static final SurfaceTerrainConfig CRYSTAL_SPIRES_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(0.6f).withHeightVariation(0.26f).withRidgeWeight(0.0f);
    public static final SurfaceTerrainConfig FOREST_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(0.155f).withHeightVariation(0.07f);
    public static final SurfaceTerrainConfig VALLEY_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(-1.2f).withHeightVariation(0.05f).withRidgeWeight(0.0f).wet();
    public static final SurfaceTerrainConfig PLATEAU_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(5.0f).withHeightVariation(0.01f);
    public static final SurfaceTerrainConfig PEAK_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(6.0f).withHeightVariation(0.5f);
    public static final SurfaceTerrainConfig RIDGE_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(4.5f).withHeightVariation(0.1f);
    public static final SurfaceTerrainConfig HILL_TERRAIN_CONFIG = new SurfaceTerrainConfig().withBaseHeight(2.25f).withHeightVariation(0.4f);
    public static final SurfaceBiomeConfig OBSCURED_PLATEAU_CONFIG = SurfaceBiomeConfig.builder().withTerrain(PLATEAU_TERRAIN_CONFIG).withSurface(ROCKY_SURFACE_CONFIG).withFeatures(ROCKY_FEATURE_CONFIG).withSpawner(PLATEAU_SPAWN_CONFIG).build();
    public static final SurfaceBiomeConfig OBSCURED_PEAK_CONFIG = SurfaceBiomeConfig.builder().withTerrain(PEAK_TERRAIN_CONFIG).withSurface(ROCKY_SURFACE_CONFIG).withFeatures(ROCKY_FEATURE_CONFIG).withSpawner(ROCKY_SPAWN_CONFIG).build();
    public static final SurfaceBiomeConfig BLACK_RIDGE_CONFIG = SurfaceBiomeConfig.builder().withTerrain(RIDGE_TERRAIN_CONFIG).withSurface(ROCKY_SURFACE_CONFIG).withFeatures(ROCKY_FEATURE_CONFIG).withSpawner(ROCKY_SPAWN_CONFIG).build();
    public static final SurfaceBiomeConfig PHANTASMAL_VALLEY_CONFIG = SurfaceBiomeConfig.builder().withTerrain(VALLEY_TERRAIN_CONFIG).withFeatures(VALLEY_FEATURE_CONFIG).withSpawner(VALLEY_SPAWN_CONFIG).build();
    public static final SurfaceBiomeConfig VIGILANT_FOREST_CONFIG = SurfaceBiomeConfig.builder().withTerrain(FOREST_TERRAIN_CONFIG).withFeatures(VIGILANT_FOREST_FEATURE_CONFIG).withSpawner(VIGILANT_FOREST_SPAWN_CONFIG).build();
    public static final SurfaceBiomeConfig HILLY_VIGILANT_FOREST_CONFIG = SurfaceBiomeConfig.builder().withTerrain(HILL_TERRAIN_CONFIG).withFeatures(VIGILANT_FOREST_FEATURE_CONFIG).withSpawner(VIGILANT_FOREST_SPAWN_CONFIG).build();
    public static final SurfaceBiomeConfig RUNEBUSH_GROVE_CONFIG = SurfaceBiomeConfig.builder().withTerrain(FOREST_TERRAIN_CONFIG).withFeatures(RUNEBUSH_GROVE_FEATURE_CONFIG).withSpawner(VEGETATED_SPAWN_CONFIG).withGrassColor(9209020).build();
    public static final SurfaceBiomeConfig FUNGI_FOREST_CONFIG = SurfaceBiomeConfig.builder().withTerrain(FOREST_TERRAIN_CONFIG).withFeatures(FUNGI_FOREST_FEATURE_CONFIG).withSpawner(FUNGI_FOREST_SPAWN_CONFIG).withGrassColor(8686005).build();
    public static final SurfaceBiomeConfig HILLY_FUNGI_FOREST_CONFIG = SurfaceBiomeConfig.builder().withTerrain(HILL_TERRAIN_CONFIG).withFeatures(FUNGI_FOREST_FEATURE_CONFIG).withSpawner(FUNGI_FOREST_SPAWN_CONFIG).withGrassColor(8686005).build();
    public static final SurfaceBiomeConfig CRYSTAL_SPIRES_CONFIG = SurfaceBiomeConfig.builder().withTerrain(CRYSTAL_SPIRES_TERRAIN_CONFIG).withFeatures(CRYSTAL_SPIRES_FEATURE_CONFIG).withSpawner(CRYSTAL_SPIRES_SPAWN_CONFIG).withGrassColor(13731004).build();
    public static final SurfaceBiomeConfig WARPED_FIELDS_CONFIG = SurfaceBiomeConfig.builder().withTerrain(WARPED_TERRAIN_CONFIG).withFeatures(WARPED_FIELDS_FEATURE_CONFIG).withSpawner(WARPED_FIELDS_SPAWN_CONFIG).build();
    public static final SurfaceBiomeConfig DECEITFUL_BOG_CONFIG = SurfaceBiomeConfig.builder().withTerrain(BOG_TERRAIN_CONFIG).withFeatures(DECEITFUL_BOG_FEATURE_CONFIG).withSpawner(DECEITFUL_BOG_SPAWN_CONFIG).withGrassColor(8950701).build();
    public static final SurfaceBiomeConfig NIGHT_PLAINS_CONFIG = SurfaceBiomeConfig.builder().withTerrain(PLAINS_TERRAIN_CONFIG).withFeatures(NIGHT_PLAINS_FEATURE_CONFIG).withSpawner(NIGHT_PLAINS_SPAWN_CONFIG).withGrassColor(12231622).build();
    public static final CavernStructureConfig GREAT_CAVERN_STRUCTURE_CONFIG = new CavernStructureConfig().withCaveRadiusScale(0.0f).withHeightVariation(0.4f);
    public static final CavernStructureConfig FUNGAL_CAVERN_STRUCTURE_CONFIG = new CavernStructureConfig().withCavernDensity(-15.0f).withPillarWeight(0.0f).withFloorHeight(0.1f).withCeilingHeight(0.8f).withHeightVariation(0.6f);
    public static final CavernousBiomeConfig GREAT_CAVERN_CONFIG = CavernousBiomeConfig.builder().withSpawner(GREAT_CAVERN_SPAWN_CONFIG).withFeatures(GREAT_CAVERN_FEATURE_CONFIG).withStructure(GREAT_CAVERN_STRUCTURE_CONFIG).build();
    public static final CavernousBiomeConfig CRYSTAL_CAVERN_CONFIG = CavernousBiomeConfig.builder().withSpawner(CRYSTAL_CAVERN_SPAWN_CONFIG).withFeatures(CRYSTAL_CAVERN_FEATURE_CONFIG).withStructure(GREAT_CAVERN_STRUCTURE_CONFIG).build();
    public static final CavernousBiomeConfig FUNGAL_CAVERN_CONFIG = CavernousBiomeConfig.builder().withSurface(new SurfaceConfig().withTopState(ModBlocks.MIDNIGHT_MYCELIUM.func_176223_P()).withFillerState(ModBlocks.NIGHTSTONE.func_176223_P()).withWetState(ModBlocks.NIGHTSTONE.func_176223_P())).withSpawner(FUNGAL_CAVERN_SPAWN_CONFIG).withFeatures(FUNGAL_CAVERN_FEATURE_CONFIG).withStructure(FUNGAL_CAVERN_STRUCTURE_CONFIG).build();
}

