/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import com.mushroom.midnight.client.particle.MidnightParticleSprites;
import com.mushroom.midnight.client.particle.RiftParticleSystem;
import com.mushroom.midnight.common.entity.EntityRift;
import com.mushroom.midnight.common.util.MatrixStack;
import javax.vecmath.Point3d;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.MathHelper;

public class RiftParticle
extends Particle {
    private static final int TRANSITION_TIME = 20;
    private static final float MIN_RETURN_DISTANCE = 0.2f;
    private static final int MIN_RETURN_CHANCE = 400;
    private static final int RETURN_DECAY_TIME = 98;
    private final RiftParticleSystem particleSystem;
    private final RiftParticleSystem.Ring ring;
    private final Point3d origin;
    private final float radius;
    private final float angleOffset;
    private final float verticalOffset;
    private final float rotateSpeed;
    private final MatrixStack matrix = new MatrixStack(4);
    private int transitionTime;
    private boolean returning;

    public RiftParticle(RiftParticleSystem particleSystem, RiftParticleSystem.Ring ring, double x, double y, double z, float radius, float angleOffset, float verticalOffset, float rotateSpeed) {
        super(particleSystem.getEntity().field_70170_p, x, y, z);
        float shade;
        this.func_187115_a(0.2f, 0.2f);
        this.func_187117_a(MidnightParticleSprites.getSprite(MidnightParticleSprites.SpriteTypes.SPORE));
        this.particleSystem = particleSystem;
        this.radius = radius;
        this.angleOffset = angleOffset;
        this.verticalOffset = verticalOffset;
        this.rotateSpeed = rotateSpeed;
        this.ring = ring;
        this.origin = new Point3d(x, y, z);
        this.field_70552_h = shade = this.field_187136_p.nextFloat() * 0.1f + 0.2f;
        this.field_70553_i = shade;
        this.field_70551_j = shade;
        this.field_70544_f *= (this.field_187136_p.nextFloat() * 0.6f + 2.0f) * 0.3f;
        this.field_190017_n = false;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        EntityRift rift = this.particleSystem.getEntity();
        if (this.shouldExpire() || !rift.isBridgeValid()) {
            this.func_187112_i();
            this.particleSystem.returnParticle();
            return;
        }
        int gradient = 4;
        int returnChance = MathHelper.func_76125_a((int)(gradient * (98 - rift.getBridge().unstable.getTimer())), (int)1, (int)400);
        if (this.field_187136_p.nextInt(returnChance) == 0) {
            this.returning = true;
        }
        this.updateTransitionTimer();
        float transitionAnimation = (float)this.transitionTime / 20.0f;
        transitionAnimation = (float)(1.0 - Math.pow(1.0f - transitionAnimation, 3.0));
        Point3d target = this.computeTarget();
        this.field_187126_f = this.origin.x + (target.x - this.origin.x) * (double)transitionAnimation;
        this.field_187127_g = this.origin.y + (target.y - this.origin.y) * (double)transitionAnimation;
        this.field_187128_h = this.origin.z + (target.z - this.origin.z) * (double)transitionAnimation;
        ++this.field_70546_d;
    }

    private void updateTransitionTimer() {
        if (this.returning && this.transitionTime > 0) {
            --this.transitionTime;
        } else if (this.transitionTime < 20) {
            ++this.transitionTime;
        }
    }

    private boolean shouldExpire() {
        if (this.particleSystem.getEntity().field_70128_L) {
            return true;
        }
        if (this.returning) {
            double deltaX = this.field_187126_f - this.origin.x;
            double deltaY = this.field_187127_g - this.origin.y;
            double deltaZ = this.field_187128_h - this.origin.z;
            double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
            return distanceSq < 0.04000000283122063;
        }
        return false;
    }

    private Point3d computeTarget() {
        this.matrix.push();
        this.matrix.rotate(this.ring.getTiltX(), 1.0, 0.0, 0.0);
        this.matrix.rotate(this.ring.getTiltZ(), 0.0, 0.0, 1.0);
        this.matrix.rotate((float)this.field_70546_d * this.rotateSpeed + this.angleOffset, 0.0, 1.0, 0.0);
        Point3d point = new Point3d((double)this.radius, (double)this.verticalOffset, 0.0);
        this.matrix.transform(point);
        this.matrix.pop();
        EntityRift rift = this.particleSystem.getEntity();
        double targetX = rift.field_70165_t + point.x;
        double targetY = rift.field_70163_u + (double)(rift.field_70131_O / 2.0f) + point.y;
        double targetZ = rift.field_70161_v + point.z;
        return new Point3d(targetX, targetY, targetZ);
    }

    public int func_70537_b() {
        return 1;
    }
}

