/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.client.particle;

import com.mushroom.midnight.common.helper.Helper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BombExplosionParticle
extends Particle {
    private static final ResourceLocation EXPLOSION_TEXTURE = new ResourceLocation("midnight", "textures/particles/bomb_explosion.png");
    private static final VertexFormat VERTEX_FORMAT = new VertexFormat().func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(DefaultVertexFormats.field_181714_n).func_181721_a(DefaultVertexFormats.field_181716_p).func_181721_a(DefaultVertexFormats.field_181717_q).func_181721_a(DefaultVertexFormats.field_181718_r);
    private int life;
    private final int lifeTime;
    private final TextureManager textureManager;
    private final float size;

    protected BombExplosionParticle(TextureManager textureManager, World world, double x, double y, double z, double scale, double unused1, double unused2, int color) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.textureManager = textureManager;
        this.lifeTime = 6 + this.field_187136_p.nextInt(4);
        float[] rgbF = Helper.getRGBColorF(color);
        this.func_70538_b(rgbF[0], rgbF[1], rgbF[2]);
        this.size = 1.0f - (float)scale * 0.5f;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        int i = (int)(((float)this.life + partialTicks) * 15.0f / (float)this.lifeTime);
        if (i <= 15) {
            this.textureManager.func_110577_a(EXPLOSION_TEXTURE);
            double minU = (double)(i % 4) / 4.0;
            double maxU = minU + 0.24975;
            double minV = (double)(i / 4) / 4.0;
            double maxV = minV + 0.24975;
            double scale = 2.0 * (double)this.size;
            int skyLight = 0;
            int blockLight = 240;
            double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an;
            double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao;
            double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            RenderHelper.func_74518_a();
            buffer.func_181668_a(7, VERTEX_FORMAT);
            buffer.func_181662_b(x - (double)rotationX * scale - (double)rotationXY * scale, y - (double)rotationZ * scale, z - (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(maxU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(skyLight, blockLight).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b(x - (double)rotationX * scale + (double)rotationXY * scale, y + (double)rotationZ * scale, z - (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(maxU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(skyLight, blockLight).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b(x + (double)rotationX * scale + (double)rotationXY * scale, y + (double)rotationZ * scale, z + (double)rotationYZ * scale + (double)rotationXZ * scale).func_187315_a(minU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(skyLight, blockLight).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b(x + (double)rotationX * scale - (double)rotationXY * scale, y - (double)rotationZ * scale, z + (double)rotationYZ * scale - (double)rotationXZ * scale).func_187315_a(minU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f).func_187314_a(skyLight, blockLight).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179145_e();
        }
    }

    public int func_189214_a(float partialTick) {
        return 61680;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        ++this.life;
        if (this.life == this.lifeTime) {
            this.func_187112_i();
        }
    }

    public int func_70537_b() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        @Nullable
        public Particle func_178902_a(int particleID, World world, double x, double y, double z, double scale, double unused1, double unused2, int ... params) {
            return new BombExplosionParticle(Minecraft.func_71410_x().func_110434_K(), world, x, y, z, scale, 0.0, 0.0, params.length > 0 ? params[0] : 0xFFFFFF);
        }
    }
}

