/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.generator;

import com.mushroom.midnight.common.biome.surface.SurfaceBiome;
import com.mushroom.midnight.common.registry.ModBlocks;
import com.mushroom.midnight.common.world.PartialChunkGenerator;
import com.mushroom.midnight.common.world.noise.INoiseSampler;
import com.mushroom.midnight.common.world.noise.PerlinNoiseSampler;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class WorldGenMoltenCrater
extends MapGenBase {
    private static final Random RNG = new Random(0L);
    private static final int SPAWN_CHANCE = 350;
    private static final int MIN_RADIUS = 16;
    private static final int MAX_RADIUS = 42;
    private static final int MAX_GENERATION_Y = 86;
    private static final int SCALE_Y = 2;
    private static final int EDGE_DEPTH = 12;
    private static final int POOL_DEPTH = 3;
    private static final IBlockState AIR_STATE = Blocks.field_150350_a.func_176223_P();
    private static final IBlockState MIASMA_STATE = ModBlocks.MIASMA.func_176223_P();
    private static final IBlockState SURFACE_STATE = ModBlocks.TRENCHSTONE.func_176223_P();
    private final PartialChunkGenerator generator;
    private final INoiseSampler noiseSampler;
    private final double[] noiseBuffer = new double[65536];

    public WorldGenMoltenCrater(Random random, PartialChunkGenerator generator) {
        this.generator = generator;
        this.field_75040_a = MathHelper.func_76143_f((double)3.375);
        this.noiseSampler = new PerlinNoiseSampler(random);
        this.noiseSampler.setFrequency(0.001);
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int genChunkX, int genChunkZ, ChunkPrimer primer) {
        if (this.field_75038_b.nextInt(350) == 0) {
            ChunkPrimer contextPrimer = new ChunkPrimer();
            this.generator.primeChunkBare(contextPrimer, chunkX, chunkZ);
            int globalX = chunkX << 4;
            int globalZ = chunkZ << 4;
            int centerX = globalX + this.field_75038_b.nextInt(16);
            int centerZ = globalZ + this.field_75038_b.nextInt(16);
            Biome biome = world.func_72959_q().func_180631_a(new BlockPos(centerX, 0, centerZ));
            if (WorldGenMoltenCrater.isBiomeInvalid(biome)) {
                return;
            }
            int centerY = WorldGenMoltenCrater.findSurfaceFixed(contextPrimer, centerX & 0xF, centerZ & 0xF);
            if (centerY >= 86) {
                return;
            }
            int radius = this.field_75038_b.nextInt(27) + 16;
            this.generateCrater(centerX, centerY, centerZ, radius, genChunkX, genChunkZ, primer);
        }
    }

    private void generateCrater(int centerX, int centerY, int centerZ, int radius, int genChunkX, int genChunkZ, ChunkPrimer primer) {
        int edgeRadius = radius + 12;
        int minChunkX = genChunkX << 4;
        int minChunkZ = genChunkZ << 4;
        int maxChunkX = minChunkX + 15;
        int maxChunkZ = minChunkZ + 15;
        int minX = Math.max(centerX - edgeRadius, minChunkX);
        int maxX = Math.min(centerX + edgeRadius, maxChunkX);
        int minZ = Math.max(centerZ - edgeRadius, minChunkZ);
        int maxZ = Math.min(centerZ + edgeRadius, maxChunkZ);
        int minY = Math.max(centerY - edgeRadius / 2, 0);
        int maxY = Math.min(centerY + edgeRadius / 2, 255);
        if (minX >= maxX || minZ >= maxZ || minY >= maxY) {
            return;
        }
        Arrays.fill(this.noiseBuffer, 0.0);
        this.noiseSampler.sample3D(this.noiseBuffer, minChunkX, 0.0, minChunkZ, 16, 256, 16);
        BlockPos minPos = new BlockPos(minX, minY, minZ);
        BlockPos maxPos = new BlockPos(maxX, maxY, maxZ);
        this.carveCrater(centerX, centerY, centerZ, radius, edgeRadius, minPos, maxPos, primer);
        this.decorateSurface(centerX, centerZ, edgeRadius, minPos, maxPos, primer);
    }

    private void carveCrater(int centerX, int centerY, int centerZ, int radius, int edgeRadius, BlockPos minPos, BlockPos maxPos, ChunkPrimer primer) {
        int radiusSquared = radius * radius;
        int edgeRadiusSquared = edgeRadius * edgeRadius;
        int poolLevel = centerY - radius / 2 + 3;
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            int localX = pos.func_177958_n() & 0xF;
            int localY = pos.func_177956_o() & 0xFF;
            int localZ = pos.func_177952_p() & 0xF;
            double noise = (this.noiseBuffer[localY + (localX + localZ * 16) * 16] + 1.0) * 8.0;
            double distanceSquared = this.computeDistanceSquared(pos, centerX, centerY, centerZ) + noise * noise;
            if (!(distanceSquared <= (double)edgeRadiusSquared)) continue;
            if (distanceSquared < (double)radiusSquared) {
                this.carveCraterBlock(primer, poolLevel, localX, localY, localZ);
                continue;
            }
            this.hardenEdgeBlock(primer, localX, localY, localZ);
        }
    }

    private void carveCraterBlock(ChunkPrimer primer, int poolLevel, int localX, int localY, int localZ) {
        if (primer.func_177856_a(localX, localY, localZ) == AIR_STATE) {
            return;
        }
        if (localY <= poolLevel) {
            primer.func_177855_a(localX, localY, localZ, MIASMA_STATE);
        } else {
            primer.func_177855_a(localX, localY, localZ, AIR_STATE);
        }
    }

    private void hardenEdgeBlock(ChunkPrimer primer, int localX, int localY, int localZ) {
        IBlockState currentState = primer.func_177856_a(localX, localY, localZ);
        if (currentState.func_185917_h()) {
            primer.func_177855_a(localX, localY, localZ, SURFACE_STATE);
        }
    }

    private void decorateSurface(int centerX, int centerZ, int edgeRadius, BlockPos minPos, BlockPos maxPos, ChunkPrimer primer) {
        int edgeRadiusSquared = edgeRadius * edgeRadius;
        for (int z = minPos.func_177952_p(); z <= maxPos.func_177952_p(); ++z) {
            for (int x = minPos.func_177958_n(); x <= maxPos.func_177958_n(); ++x) {
                IBlockState state;
                int localZ;
                int localY;
                int localX;
                int deltaX = x - centerX;
                int deltaZ = z - centerZ;
                int distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                if (distanceSquared > edgeRadiusSquared || primer.func_177856_a(localX = x & 0xF, localY = WorldGenMoltenCrater.findSurfaceFixed(primer, localX, localZ = z & 0xF), localZ) != SURFACE_STATE || (state = this.selectSurfaceState()) == null) continue;
                primer.func_177855_a(localX, localY, localZ, state);
            }
        }
    }

    @Nullable
    private IBlockState selectSurfaceState() {
        float chance = this.field_75038_b.nextFloat();
        if (chance > 0.95f) {
            return MIASMA_STATE;
        }
        if (chance > 0.7f) {
            return ModBlocks.MIASMA_SURFACE.func_176223_P();
        }
        return null;
    }

    private double computeDistanceSquared(BlockPos pos, int centerX, int centerY, int centerZ) {
        int deltaX = pos.func_177958_n() - centerX;
        int deltaY = Math.min(pos.func_177956_o() - centerY, 0) * 2;
        int deltaZ = pos.func_177952_p() - centerZ;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    private static int findSurfaceFixed(ChunkPrimer primer, int x, int z) {
        if (x != 15 && z != 15) {
            return primer.func_186138_a(x, z) - 1;
        }
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(x, y, z);
            if (state == AIR_STATE) continue;
            return y;
        }
        return 0;
    }

    public static boolean isCraterSource(World world, int chunkX, int chunkZ) {
        RNG.setSeed(world.func_72905_C());
        long seedX = (long)chunkX * RNG.nextLong();
        long seedZ = (long)chunkZ * RNG.nextLong();
        RNG.setSeed(seedX ^ seedZ ^ world.func_72905_C());
        if (RNG.nextInt(350) != 0) {
            return false;
        }
        int centerX = (chunkX << 4) + RNG.nextInt(16);
        int centerZ = (chunkZ << 4) + RNG.nextInt(16);
        Biome biome = world.func_72959_q().func_180631_a(new BlockPos(centerX, 0, centerZ));
        return !WorldGenMoltenCrater.isBiomeInvalid(biome);
    }

    private static boolean isBiomeInvalid(Biome biome) {
        return SurfaceBiome.getTerrainConfig(biome).isWet();
    }
}

