/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.creature.EntityRifter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityTaskRifterTeleport
extends EntityAIBase {
    private static final double MAX_DISTANCE_SQ = 576.0;
    private static final int MIN_IDLE_TIME = 40;
    private final EntityRifter owner;

    public EntityTaskRifterTeleport(EntityRifter owner) {
        this.owner = owner;
    }

    public boolean func_75250_a() {
        if (!MidnightConfig.general.allowRifterTeleport || this.owner.func_70681_au().nextInt(10) != 0) {
            return false;
        }
        EntityLivingBase target = this.owner.func_70638_az();
        if (target == null || this.owner.getTargetIdleTime() < 40) {
            return false;
        }
        double distanceSq = target.func_70068_e((Entity)this.owner);
        return distanceSq < 576.0 && !this.canBeSeen();
    }

    public void func_75249_e() {
        EntityLivingBase attackTarget = this.owner.func_70638_az();
        if (attackTarget == null) {
            return;
        }
        BlockPos target = this.computeTeleportTarget(attackTarget);
        if (target != null) {
            this.owner.field_70177_z = attackTarget.field_70177_z;
            this.owner.func_70634_a((double)target.func_177958_n() + 0.5, target.func_177956_o(), (double)target.func_177952_p() + 0.5);
            this.owner.func_70642_aH();
            this.owner.func_70661_as().func_75499_g();
        }
    }

    private BlockPos computeTeleportTarget(EntityLivingBase target) {
        BlockPos origin = target.func_180425_c();
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)origin.func_177982_a(-2, -2, -2), (BlockPos)origin.func_177982_a(2, 2, 2))) {
            Vec3d vector = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (this.canBeSeenBy(vector, target) || !this.isTargetValid(pos)) continue;
            validPositions.add(pos.func_185334_h());
        }
        if (validPositions.isEmpty()) {
            return null;
        }
        return (BlockPos)validPositions.get(this.owner.func_70681_au().nextInt(validPositions.size()));
    }

    private boolean isTargetValid(BlockPos target) {
        if (this.owner.field_70170_p.func_184143_b(this.getEntityBoundAt((Entity)this.owner, target))) {
            return false;
        }
        return this.owner.func_70661_as().func_179680_a(target) != null;
    }

    private AxisAlignedBB getEntityBoundAt(Entity entity, BlockPos pos) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        float halfWidth = entity.field_70130_N / 2.0f;
        return new AxisAlignedBB(x - (double)halfWidth, y, z - (double)halfWidth, x + (double)halfWidth, y + (double)entity.field_70131_O, z + (double)halfWidth);
    }

    public boolean func_75253_b() {
        return false;
    }

    private boolean canBeSeen() {
        List players = this.owner.field_70170_p.func_72872_a(EntityPlayer.class, this.owner.func_174813_aQ().func_186662_g(24.0));
        for (EntityPlayer player : players) {
            if (!this.canBeSeenBy(this.owner.func_174791_d(), (EntityLivingBase)player)) continue;
            return true;
        }
        return false;
    }

    private boolean canBeSeenBy(Vec3d position, EntityLivingBase entity) {
        Vec3d playerLook = entity.func_70676_i(1.0f);
        Vec3d deltaPos = entity.func_174791_d().func_178788_d(position);
        return playerLook.func_72430_b(deltaPos = deltaPos.func_72432_b()) < 0.0;
    }
}

