/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.projectile;

import com.mushroom.midnight.client.particle.MidnightParticles;
import com.mushroom.midnight.common.registry.ModCriterion;
import com.mushroom.midnight.common.registry.ModItems;
import com.mushroom.midnight.common.registry.ModLootTables;
import com.mushroom.midnight.common.registry.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityThrownGeode
extends EntityThrowable {
    private static final byte POPPED_STATE_ID = 3;

    public EntityThrownGeode(World world) {
        super(world);
    }

    public EntityThrownGeode(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityThrownGeode(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            this.spawnPopParticles();
        }
    }

    private void spawnPopParticles() {
        int i;
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.EGG_CRACKED, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
        for (i = 0; i < 8; ++i) {
            double velX = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            double velY = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v, velX, 0.1, velY, new int[]{Item.func_150891_b((Item)ModItems.GEODE)});
        }
        for (i = 0; i < 2; ++i) {
            double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
            double offsetY = (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
            double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 0.4;
            MidnightParticles.FURNACE_FLAME.spawn(this.field_70170_p, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            DamageSource source = DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h());
            result.field_72308_g.func_70097_a(source, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.canBreakOn(result.func_178782_a())) {
                EntityPlayerMP player;
                EntityPlayerMP entityPlayerMP = player = this.field_70192_c instanceof EntityPlayerMP ? (EntityPlayerMP)this.field_70192_c : null;
                if (player != null) {
                    ModCriterion.THROWN_GEODE.trigger(player);
                }
                this.dropLootWhenBroken(player);
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            } else {
                this.func_145779_a(ModItems.GEODE, 1);
            }
            this.func_70106_y();
        }
    }

    private boolean canBreakOn(@Nullable BlockPos impactedPos) {
        IBlockState impactedState;
        return impactedPos != null && ((impactedState = this.field_70170_p.func_180495_p(impactedPos)).func_185904_a() == Material.field_151576_e || impactedState.func_185904_a() == Material.field_151573_f);
    }

    private void dropLootWhenBroken(@Nullable EntityPlayerMP player) {
        LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(DamageSource.field_76377_j);
        if (player != null) {
            builder = builder.func_186470_a((EntityPlayer)player).func_186469_a(player.func_184817_da());
        }
        LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(ModLootTables.LOOT_TABLE_THROWN_GEODE);
        for (ItemStack itemstack : loottable.func_186462_a(this.field_70146_Z, builder.func_186471_a())) {
            this.func_70099_a(itemstack, 0.1f);
        }
    }
}

