/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import com.mushroom.midnight.client.particle.MidnightParticles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.PotionTypes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EntityCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityCloud.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNORE_RADIUS = EntityDataManager.func_187226_a(EntityCloud.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> PARTICLE = EntityDataManager.func_187226_a(EntityCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PARTICLE_PARAM = EntityDataManager.func_187226_a(EntityCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private PotionType potion = PotionTypes.field_185229_a;
    private final List<PotionEffect> effects = new ArrayList<PotionEffect>();
    private final Map<Entity, Integer> reapplicationDelayMap = new HashMap<Entity, Integer>();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean colorSet;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private EntityLivingBase owner;
    private UUID ownerUniqueId;
    private boolean allowTeleport = false;

    public EntityCloud(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.setRadius(3.0f);
    }

    public EntityCloud(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityCloud setAllowTeleport() {
        this.allowTeleport = true;
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(IGNORE_RADIUS, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(PARTICLE, (Object)MidnightParticles.AMBIENT_SPORE.ordinal());
        this.field_70180_af.func_187214_a(PARTICLE_PARAM, (Object)0);
    }

    public EntityCloud setRadius(float radius) {
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        this.func_70105_a(radius * 2.0f, 0.5f);
        this.func_70107_b(x, y, z);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(RADIUS, (Object)Float.valueOf(radius));
        }
        return this;
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue();
    }

    public EntityCloud setPotion(PotionType potion) {
        this.potion = potion;
        if (!this.colorSet) {
            this.updateFixedColor();
        }
        return this;
    }

    private void updateFixedColor() {
        if (this.potion == PotionTypes.field_185229_a && this.effects.isEmpty()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)0);
        } else {
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((PotionType)this.potion, this.effects)));
        }
    }

    public EntityCloud addEffect(PotionEffect effect) {
        this.effects.add(effect);
        if (!this.colorSet) {
            this.updateFixedColor();
        }
        return this;
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public EntityCloud setColor(int color) {
        this.colorSet = true;
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
        return this;
    }

    public MidnightParticles getParticle() {
        return MidnightParticles.fromId((Integer)this.field_70180_af.func_187225_a(PARTICLE));
    }

    public EntityCloud setParticle(MidnightParticles particle) {
        this.field_70180_af.func_187227_b(PARTICLE, (Object)particle.ordinal());
        return this;
    }

    public int getParticleParam() {
        return (Integer)this.field_70180_af.func_187225_a(PARTICLE_PARAM);
    }

    public EntityCloud setParticleParam(int param) {
        this.field_70180_af.func_187227_b(PARTICLE_PARAM, (Object)param);
        return this;
    }

    protected void setIgnoreRadius(boolean ignoreRadius) {
        this.field_70180_af.func_187227_b(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    public boolean shouldIgnoreRadius() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNORE_RADIUS);
    }

    public int getDuration() {
        return this.duration;
    }

    public EntityCloud setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        boolean flag = this.shouldIgnoreRadius();
        float f = this.getRadius();
        if (this.field_70170_p.field_72995_K) {
            MidnightParticles particle = this.getParticle();
            if (flag) {
                if (this.field_70146_Z.nextBoolean()) {
                    for (int i = 0; i < 2; ++i) {
                        float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float f2 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * 0.2f;
                        float f3 = MathHelper.func_76134_b((float)f1) * f2;
                        float f4 = MathHelper.func_76126_a((float)f1) * f2;
                        particle.spawn(this.field_70170_p, this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)f4, 0.0, 0.0, 0.0, this.getParticleParam());
                    }
                }
            } else {
                float f5 = (float)Math.PI * f * f;
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * f;
                    float f8 = MathHelper.func_76134_b((float)f6) * f7;
                    float f9 = MathHelper.func_76126_a((float)f6) * f7;
                    particle.spawn(this.field_70170_p, this.field_70165_t + (double)f8, this.field_70163_u, this.field_70161_v + (double)f9, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, 0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, this.getParticleParam());
                    ++k1;
                }
            }
        } else {
            boolean flag1;
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            boolean bl = flag1 = this.field_70173_aa < this.waitTime;
            if (flag != flag1) {
                this.setIgnoreRadius(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(f);
            }
            if (this.field_70173_aa % 5 == 0) {
                this.reapplicationDelayMap.entrySet().removeIf(entry -> this.field_70173_aa >= (Integer)entry.getValue());
                ArrayList<PotionEffect> potions = new ArrayList<PotionEffect>();
                for (PotionEffect effect : this.potion.func_185170_a()) {
                    potions.add(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() / 4, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                }
                potions.addAll(this.effects);
                if (potions.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    List list2 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
                    if (!list2.isEmpty()) {
                        for (EntityLivingBase entity : list2) {
                            double d1;
                            double d0;
                            double d2;
                            if (this.reapplicationDelayMap.containsKey(entity) || !entity.func_184603_cC() || !((d2 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) <= (double)(f * f))) continue;
                            this.reapplicationDelayMap.put((Entity)entity, this.field_70173_aa + this.reapplicationDelay);
                            for (PotionEffect effect : potions) {
                                if (effect.func_188419_a().func_76403_b()) {
                                    effect.func_188419_a().func_180793_a((Entity)this, (Entity)this.getOwner(), entity, effect.func_76458_c(), 0.5);
                                    continue;
                                }
                                entity.func_70690_d(new PotionEffect(effect));
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((f += this.radiusOnUse) < 0.5f) {
                                    this.func_70106_y();
                                    return;
                                }
                                this.setRadius(f);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.func_70106_y();
                            return;
                        }
                    }
                }
            }
        }
        if (this.allowTeleport && !this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70170_p.func_82737_E() % 40L == 0L && !(list = this.field_70170_p.func_175674_a((Entity)this.getOwner(), this.func_174813_aQ().func_186662_g(5.0), p -> p instanceof EntityLivingBase && p.func_70089_S())).isEmpty()) {
            Entity entity = (Entity)list.get(this.field_70170_p.field_73012_v.nextInt(list.size()));
            this.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }

    public EntityCloud setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
        return this;
    }

    public EntityCloud setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
        return this;
    }

    public EntityCloud setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
        return this;
    }

    public EntityCloud setOwner(@Nullable EntityLivingBase owner) {
        this.owner = owner;
        this.ownerUniqueId = owner == null ? null : owner.func_110124_au();
        return this;
    }

    @Nullable
    public EntityLivingBase getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.ownerUniqueId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
        return this.owner;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.waitTime = compound.func_74762_e("WaitTime");
        this.reapplicationDelay = compound.func_74762_e("ReapplicationDelay");
        this.durationOnUse = compound.func_74762_e("DurationOnUse");
        this.radiusOnUse = compound.func_74760_g("RadiusOnUse");
        this.radiusPerTick = compound.func_74760_g("RadiusPerTick");
        this.setRadius(compound.func_74760_g("Radius"));
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
        if (compound.func_150297_b("particle_id", 3)) {
            this.setParticle(MidnightParticles.fromId(compound.func_74762_e("particle_id")));
        }
        if (compound.func_150297_b("particle_param", 3)) {
            this.setParticleParam(compound.func_74762_e("particle_param"));
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setColor(compound.func_74762_e("Color"));
        }
        if (compound.func_150297_b("Potion", 8)) {
            this.setPotion(PotionUtils.func_185187_c((NBTTagCompound)compound));
        }
        if (compound.func_150297_b("Effects", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)nbttaglist.func_150305_b(i));
                if (effect == null) continue;
                this.addEffect(effect);
            }
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("WaitTime", this.waitTime);
        compound.func_74768_a("ReapplicationDelay", this.reapplicationDelay);
        compound.func_74768_a("DurationOnUse", this.durationOnUse);
        compound.func_74776_a("RadiusOnUse", this.radiusOnUse);
        compound.func_74776_a("RadiusPerTick", this.radiusPerTick);
        compound.func_74776_a("Radius", this.getRadius());
        compound.func_74768_a("particle_id", this.getParticle().ordinal());
        compound.func_74768_a("particle_param", this.getParticleParam());
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
        if (this.colorSet) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (this.potion != PotionTypes.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", ((ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)this.potion)).toString());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect effect : this.effects) {
                nbttaglist.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("Effects", (NBTBase)nbttaglist);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
        }
        super.func_184206_a(key);
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }
}

