/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.client.particle.MidnightParticles;
import com.mushroom.midnight.common.block.BlockMidnightPlant;
import com.mushroom.midnight.common.block.BlockUnstableBush;
import com.mushroom.midnight.common.block.PlantBehaviorType;
import com.mushroom.midnight.common.item.ItemUnstableFruit;
import com.mushroom.midnight.common.registry.ModBlocks;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockUnstableBushBloomed
extends BlockMidnightPlant
implements IGrowable {
    public static final PropertyBool HAS_FRUIT = PropertyBool.func_177716_a((String)"has_fruit");
    private final Supplier<Item> fruitSupplier;
    protected static final AxisAlignedBB BOUND = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockUnstableBushBloomed(Supplier<Item> fruitSupplier) {
        super(PlantBehaviorType.FLOWER, true);
        this.fruitSupplier = fruitSupplier;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)HAS_FRUIT)).booleanValue()) {
            if (!world.field_72995_K) {
                int fruitCount = world.field_73012_v.nextInt(3) + 1;
                for (int i = 0; i < fruitCount; ++i) {
                    EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), new ItemStack(this.fruitSupplier.get()));
                    world.func_72838_d((Entity)entityitem);
                    entityitem.func_70091_d(MoverType.SELF, (double)(world.field_73012_v.nextFloat() * 0.12f - 0.06f), (double)-0.06f, (double)(world.field_73012_v.nextFloat() * 0.12f - 0.06f));
                }
                world.func_180501_a(pos, ModBlocks.UNSTABLE_BUSH.func_176223_P().func_177226_a((IProperty)BlockUnstableBush.STAGE, (Comparable)Integer.valueOf(4)), 2);
            }
            return true;
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HAS_FRUIT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_FRUIT) != false ? 1 : 0;
    }

    public boolean func_149700_E() {
        return false;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.fruitSupplier.get();
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return random.nextInt(3) + ((Boolean)state.func_177229_b((IProperty)HAS_FRUIT) != false ? 3 : 0);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)HAS_FRUIT) == false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_FRUIT) == false;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 2);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.func_180671_f(world, pos, state)) {
            world.func_175655_b(pos, true);
        } else if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (rand.nextInt(10) == 0 ? 1 : 0) != 0)) {
            this.func_176474_b(world, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
        }
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.fruitSupplier.get());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int fruitType;
        int n = fruitType = this.fruitSupplier.get() instanceof ItemUnstableFruit ? ((ItemUnstableFruit)this.fruitSupplier.get()).fruitColor.ordinal() : 0;
        if (rand.nextInt(10) == 0) {
            MidnightParticles.UNSTABLE_BUSH.spawn(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)rand.nextFloat() * 0.1 - 0.05, (double)rand.nextFloat() * 0.03, (double)rand.nextFloat() * 0.1 - 0.05, fruitType);
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BOUND;
    }
}

